/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.List;
import org.drools.RuleBase;
import org.drools.io.RuleBaseLoader;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentLifecycle;
import org.exoplatform.container.component.DroolRulePlugin;
import org.exoplatform.container.component.RulePlugable;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.RulePlugin;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AbstractComponentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MX4JComponentAdapter
extends AbstractComponentAdapter {
    private Object instance_;

    public MX4JComponentAdapter(Object key, Class implementation) {
        super(key, implementation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentInstance(PicoContainer container) {
        if (this.instance_ != null) {
            return this.instance_;
        }
        ExoContainer exocontainer = (ExoContainer)container;
        try {
            PicoContainer picoContainer = container;
            synchronized (picoContainer) {
                ExternalComponentPlugins ecplugins;
                Object key = this.getComponentKey();
                String componentKey = null;
                componentKey = key instanceof String ? (String)key : ((Class)key).getName();
                ConfigurationManager manager = (ConfigurationManager)exocontainer.getComponentInstanceOfType(ConfigurationManager.class);
                Component component = manager.getComponent(componentKey);
                InitParams params = null;
                boolean debug = false;
                if (component != null) {
                    params = component.getInitParams();
                    debug = component.getShowDeployInfo();
                }
                this.instance_ = exocontainer.createComponent(this.getComponentImplementation(), params);
                if (debug) {
                    this.print("==> create  component : " + this.instance_);
                }
                if (component != null && component.getComponentPlugins() != null) {
                    this.addComponentPlugin(debug, this.instance_, component.getComponentPlugins(), exocontainer);
                }
                if ((ecplugins = manager.getConfiguration().getExternalComponentPlugins(componentKey)) != null) {
                    this.addComponentPlugin(debug, this.instance_, ecplugins.getComponentPlugins(), exocontainer);
                }
                if (this.instance_ instanceof RulePlugable) {
                    RulePlugable rplugable = (RulePlugable)this.instance_;
                    this.addRulePlugin(rplugable, component.getRulePlugins(), exocontainer);
                }
                exocontainer.manageMBean(component, componentKey, this.instance_);
                if (debug) {
                    this.print("==> add " + component + " to a mbean server");
                }
                if (this.instance_ instanceof ComponentLifecycle) {
                    ComponentLifecycle lc = (ComponentLifecycle)this.instance_;
                    lc.initComponent(exocontainer);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot instantiate component " + this.getComponentImplementation(), ex);
        }
        return this.instance_;
    }

    private void addComponentPlugin(boolean debug, Object component, List<ComponentPlugin> plugins, ExoContainer container) throws Exception {
        if (plugins == null) {
            return;
        }
        for (ComponentPlugin plugin : plugins) {
            Class<?> clazz = Class.forName(plugin.getType());
            org.exoplatform.container.component.ComponentPlugin cplugin = (org.exoplatform.container.component.ComponentPlugin)container.createComponent(clazz, plugin.getInitParams());
            cplugin.setName(plugin.getName());
            cplugin.setDescription(plugin.getDescription());
            clazz = component.getClass();
            Method m = this.getSetMethod(clazz, plugin.getSetMethod());
            Object[] params = new Object[]{cplugin};
            m.invoke(component, params);
            if (debug) {
                this.print("==> add component plugin: " + cplugin);
            }
            cplugin.setName(plugin.getName());
            cplugin.setDescription(plugin.getDescription());
        }
    }

    private Method getSetMethod(Class clazz, String name) {
        Method[] methods;
        for (Method m : methods = clazz.getMethods()) {
            Class<?>[] types;
            if (!name.equals(m.getName()) || (types = m.getParameterTypes()) == null || types.length != 1 || !org.exoplatform.container.component.ComponentPlugin.class.isAssignableFrom(types[0])) continue;
            return m;
        }
        return null;
    }

    private void addRulePlugin(RulePlugable plugable, List<RulePlugin> plugins, ExoContainer container) throws Exception {
        if (plugins == null) {
            return;
        }
        ConfigurationManager cmanager = (ConfigurationManager)container.getComponentInstanceOfType(ConfigurationManager.class);
        for (RulePlugin plugin : plugins) {
            String type = plugin.getType();
            Class<?> clazz = Class.forName(type);
            DroolRulePlugin rplugin = (DroolRulePlugin)container.createComponent(clazz, plugin.getInitParams());
            URL url = cmanager.getResource(plugin.getRuleDeclaration());
            RuleBase ruleBase = RuleBaseLoader.loadFromUrl((URL)url);
            rplugin.setRuleBase(ruleBase);
            rplugin.setName(plugin.getName());
            rplugin.setDescription(plugin.getDescription());
            plugable.addRule(rplugin);
        }
    }

    public void verify(PicoContainer container) {
    }

    private void print(String message) {
    }
}

