/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ObjectQuery {
    private static SimpleDateFormat ft_ = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Class type_;
    private String orderBy_;
    private String groupBy_;
    private List parameters_;
    private List selectParameter_;

    public ObjectQuery(Class type) {
        this.type_ = type;
        this.parameters_ = new ArrayList(3);
        this.selectParameter_ = new ArrayList(10);
    }

    public ObjectQuery addEQ(String field, Object value) {
        if (value != null) {
            this.parameters_.add(new Parameter(" = ", field, value));
        }
        return this;
    }

    public ObjectQuery addGT(String field, Object value) {
        if (value != null) {
            this.parameters_.add(new Parameter(" > ", field, value));
        }
        return this;
    }

    public ObjectQuery addLT(String field, Object value) {
        if (value != null) {
            this.parameters_.add(new Parameter(" < ", field, value));
        }
        return this;
    }

    public ObjectQuery addLIKE(String field, String value) {
        if (value != null && value.length() > 0) {
            this.parameters_.add(new Parameter(" like ", field, value.replace('*', '%')));
        }
        return this;
    }

    public ObjectQuery addSUM(String field) {
        this.selectParameter_.add(new Parameter("sum", field));
        return this;
    }

    public ObjectQuery addSelect(String field) {
        this.selectParameter_.add(new Parameter("fieldselect", field));
        return this;
    }

    public ObjectQuery addSelectCount(String type) {
        this.selectParameter_.add(new Parameter("countselect", type));
        return this;
    }

    public ObjectQuery addSelectMaxMin(String op, String field) {
        this.selectParameter_.add(new Parameter(op, field));
        return this;
    }

    public ObjectQuery setGroupBy(String field) {
        this.groupBy_ = " group by o." + field;
        return this;
    }

    public ObjectQuery setAscOrderBy(String field) {
        this.orderBy_ = " order by o." + field + " asc";
        return this;
    }

    public ObjectQuery setDescOrderBy(String field) {
        this.orderBy_ = " order by o." + field + " desc";
        return this;
    }

    public String getHibernateQuery() {
        StringBuffer b = new StringBuffer();
        b.append("from o in class ").append(this.type_.getName());
        if (this.parameters_.size() > 0) {
            b.append(" where ");
            int i = 0;
            while (i < this.parameters_.size()) {
                if (i > 0) {
                    b.append(" and ");
                }
                Parameter p = (Parameter)this.parameters_.get(i);
                if (p.value_ instanceof String) {
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(p.value_).append("'");
                } else if (p.value_ instanceof Date) {
                    String value = ft_.format((Date)p.value_);
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(value).append("'");
                } else {
                    b.append(" o.").append(p.field_).append(p.op_).append(p.value_);
                }
                ++i;
            }
        }
        if (this.orderBy_ != null) {
            b.append(this.orderBy_);
        }
        return b.toString();
    }

    public String getHibernateGroupByQuery() {
        Parameter p;
        int i;
        StringBuffer b = new StringBuffer();
        b.append("select ");
        if (this.selectParameter_.size() > 0) {
            i = 0;
            while (i < this.selectParameter_.size()) {
                p = (Parameter)this.selectParameter_.get(i);
                if (p.op_.equals("fieldselect")) {
                    b.append("o.").append(p.field_);
                } else if (p.op_.equals("countselect")) {
                    b.append("count");
                    if (p.field_ != "" || p.field_.length() > 0) {
                        b.append("(").append(p.field_).append(" o)");
                    } else {
                        b.append("(o)");
                    }
                } else {
                    b.append(p.op_).append("(").append("o.").append(p.field_).append(") ");
                }
                if (i < this.selectParameter_.size() - 1) {
                    b.append(" , ");
                }
                ++i;
            }
        }
        b.append(" from o in class ").append(this.type_.getName());
        if (this.parameters_.size() > 0) {
            b.append(" where ");
            i = 0;
            while (i < this.parameters_.size()) {
                if (i > 0) {
                    b.append(" and ");
                }
                p = (Parameter)this.parameters_.get(i);
                if (p.value_ instanceof String) {
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(p.value_).append("'");
                } else if (p.value_ instanceof Date) {
                    String value = ft_.format((Date)p.value_);
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(value).append("'");
                } else if (p.op_.equals("max") || p.op_.equals("min")) {
                    b.append(p.op_).append("(").append("o.").append(p.field_).append(") ");
                } else {
                    b.append(" o.").append(p.field_).append(p.op_).append(p.value_);
                }
                ++i;
            }
        }
        if (this.groupBy_ != null) {
            b.append(this.groupBy_);
        }
        if (this.orderBy_ != null) {
            b.append(this.orderBy_);
        }
        return b.toString();
    }

    public String getHibernateCountQuery() {
        StringBuffer b = new StringBuffer();
        b.append("select count(o) from o in class ").append(this.type_.getName());
        if (this.parameters_.size() > 0) {
            b.append(" where ");
            int i = 0;
            while (i < this.parameters_.size()) {
                if (i > 0) {
                    b.append(" and ");
                }
                Parameter p = (Parameter)this.parameters_.get(i);
                if (p.value_ instanceof String) {
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(p.value_).append("'");
                } else if (p.value_ instanceof Date) {
                    String value = ft_.format((Date)p.value_);
                    b.append(" o.").append(p.field_).append(p.op_).append("'").append(value).append("'");
                } else {
                    b.append(" o.").append(p.field_).append(p.op_).append(p.value_);
                }
                ++i;
            }
        }
        return b.toString();
    }

    static class Parameter {
        String op_;
        String field_;
        String label_;
        Object value_;

        Parameter(String op, String field, Object value) {
            this.op_ = op;
            this.field_ = field;
            this.value_ = value;
        }

        Parameter(String op, String field) {
            this.op_ = op;
            this.field_ = field;
        }
    }
}

