/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.List;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationConfig;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.User;

public class OrganizationDatabaseInitializer
extends BaseComponentPlugin
implements OrganizationServiceInitializer {
    private OrganizationConfig config_;
    static /* synthetic */ Class class$0;

    public OrganizationDatabaseInitializer(InitParams params) throws Exception {
        this.config_ = (OrganizationConfig)params.getObjectParamValues(OrganizationConfig.class).get(0);
    }

    public void init(OrganizationService service) throws Exception {
        PageList users = service.getUserHandler().getUserPageList(10);
        if (users != null && users.getAvailable() > 0) {
            return;
        }
        this.createGroups(service);
        this.createMembershipTypes(service);
        this.createUsers(service);
    }

    private void createGroups(OrganizationService orgService) throws Exception {
        List groups = this.config_.getGroup();
        int i = 0;
        while (i < groups.size()) {
            OrganizationConfig.Group data = (OrganizationConfig.Group)groups.get(i);
            Group group = orgService.getGroupHandler().createGroupInstance();
            group.setGroupName(data.getName());
            group.setDescription(data.getDescription());
            String parentId = data.getParentId();
            if (parentId == null || parentId.length() == 0) {
                orgService.getGroupHandler().createGroup(group, true);
            } else {
                Group parentGroup = orgService.getGroupHandler().findGroupById(parentId);
                orgService.getGroupHandler().addChild(parentGroup, group, true);
            }
            ++i;
        }
    }

    private void createMembershipTypes(OrganizationService service) throws Exception {
        List types = this.config_.getMembershipType();
        int i = 0;
        while (i < types.size()) {
            OrganizationConfig.MembershipType data = (OrganizationConfig.MembershipType)types.get(i);
            MembershipType type = service.getMembershipTypeHandler().createMembershipTypeInstance();
            type.setName(data.getType());
            type.setDescription(data.getDescription());
            service.getMembershipTypeHandler().createMembershipType(type, true);
            ++i;
        }
    }

    private void createUsers(OrganizationService service) throws Exception {
        List users = this.config_.getUser();
        int i = 0;
        while (i < users.size()) {
            OrganizationConfig.User data = (OrganizationConfig.User)users.get(i);
            User user = service.getUserHandler().createUserInstance();
            user.setUserName(data.getUserName());
            user.setPassword(data.getPassword());
            user.setFirstName(data.getFirstName());
            user.setLastName(data.getLastName());
            user.setEmail(data.getEmail());
            service.getUserHandler().createUser(user, true);
            String groups = data.getGroups();
            String[] entry = groups.split(",");
            int j = 0;
            while (j < entry.length) {
                String[] temp = entry[j].trim().split(":");
                String membership = temp[0];
                String groupId = temp[1];
                Group group = service.getGroupHandler().findGroupById(groupId);
                MembershipType mt = service.getMembershipTypeHandler().createMembershipTypeInstance();
                mt.setName(membership);
                service.getMembershipHandler().linkMembership(user, group, mt, true);
                ++j;
            }
            ++i;
        }
    }
}

