/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.backup.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.backup.ExportLogger;
import org.exoplatform.services.backup.ImportExportPlugin;
import org.exoplatform.services.backup.ImportExportService;
import org.exoplatform.services.backup.ImportLogger;
import org.exoplatform.services.database.HibernateService;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class ImportExportServiceImpl
implements ImportExportService {
    private String directory_;
    private String userDataDir_;
    private String userTransformDir_;
    private String serviceDataDir_;
    private String serviceTransformDir_;
    private Log log_;
    private ExportLogger exportLogger_;
    private ImportLogger importLogger_;
    private OrganizationService orgService_;
    private HibernateService hservice_;
    private Map<String, ComponentPlugin> plugins_;
    private boolean printMessage = false;

    public ImportExportServiceImpl(LogService lservice, OrganizationService orgService, HibernateService hservice, InitParams params) throws Exception {
        this.orgService_ = orgService;
        this.hservice_ = hservice;
        this.log_ = lservice.getLog("org.exoplatform.services.exporter");
        this.exportLogger_ = new ExportLogger();
        this.importLogger_ = new ImportLogger();
        String backupDir = null;
        ValueParam param = params.getValueParam("backup.directory");
        if (param != null) {
            backupDir = param.getValue();
        }
        if ("default".equals(backupDir)) {
            backupDir = System.getProperty("java.io.tmpdir");
        }
        this.setDirectory(backupDir);
        this.plugins_ = new HashMap<String, ComponentPlugin>();
        param = params.getValueParam("print.message");
        if (param != null && param.getValue().trim().equalsIgnoreCase("true")) {
            this.printMessage = true;
        }
    }

    public Collection getPlugins() {
        return this.plugins_.values();
    }

    public ComponentPlugin removePlugin(String name) {
        return this.plugins_.remove(name);
    }

    public void addPlugin(ComponentPlugin plugin) {
        this.plugins_.put(plugin.getName(), plugin);
    }

    public String getDirectory() {
        return this.directory_;
    }

    public void setDirectory(String s) throws Exception {
        File dir = new File(s);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            throw new Exception(s + " is a file. Cannot create an export directory for backup service");
        }
        this.directory_ = dir.getPath();
        String userDir_ = this.createDir(this.directory_, "user");
        this.userDataDir_ = this.createDir(userDir_, "data") + File.separator;
        this.userTransformDir_ = this.createDir(userDir_, "transform") + File.separator;
        String serviceDir_ = this.createDir(this.directory_, "service");
        this.serviceDataDir_ = this.createDir(serviceDir_, "data") + File.separator;
        this.serviceTransformDir_ = this.createDir(serviceDir_, "transform") + File.separator;
    }

    private String createDir(String dir, String name) {
        String subDir_ = dir + File.separator + name;
        File file = new File(subDir_);
        if (!file.exists()) {
            file.mkdir();
        }
        return subDir_;
    }

    public String getUserDataDirectory() {
        return this.userDataDir_;
    }

    public String getServiceDataDirectory() {
        return this.serviceDataDir_;
    }

    public void exportUserData() throws Exception {
        PageList plist = this.orgService_.getUserHandler().getUserPageList(50);
        for (int i = 1; i <= plist.getAvailablePage(); ++i) {
            List list = plist.getPage(i);
            for (int j = 0; j < list.size(); ++j) {
                this.exportUserData(((User)list.get(j)).getUserName());
            }
        }
    }

    public void exportUserData(String username) throws Exception {
        String fileName = this.userDataDir_ + username + ".zip";
        File file = new File(fileName);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        this.exportUserData(username, out);
        out.close();
    }

    public void exportUserData(String username, ZipOutputStream out) throws Exception {
        try {
            for (ImportExportPlugin importExportPlugin : this.plugins_.values()) {
                if (!importExportPlugin.hasUserData()) continue;
                importExportPlugin.exportUserData(username, out);
            }
            this.hservice_.closeSession();
            this.exportLogger_.log(username);
        }
        catch (Exception ex) {
            this.exportLogger_.log(username, (Throwable)ex);
            this.hservice_.closeSession();
            this.log_.error((Object)("Error when exporting the user" + username), (Throwable)ex);
        }
    }

    public void importUserData() throws Exception {
        File dir = new File(this.userDataDir_);
        String[] file = dir.list();
        if (file.length < 1) {
            return;
        }
        for (int i = 0; i < file.length; ++i) {
            int idx = file[i].indexOf(46);
            String userName = file[i].substring(0, idx);
            ZipFile zipFile = new ZipFile(this.userDataDir_ + "/" + file[i]);
            try {
                this.importUserData(userName, zipFile);
            }
            catch (Exception ex) {
                this.log_.error((Object)("Cann't import the user " + userName), (Throwable)ex);
            }
            zipFile.close();
        }
    }

    public void importUserData(String username) throws Exception {
        String fileName = this.userDataDir_ + username + ".zip";
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        ZipFile zipFile = new ZipFile(file);
        this.importUserData(username, zipFile);
        zipFile.close();
    }

    public void importUserData(String username, ZipFile zipFile) throws Exception {
        this.printMessage("import user " + username + "...");
        try {
            this.orgService_.getUserHandler().removeUser(username, true);
            for (ImportExportPlugin importExportPlugin : this.plugins_.values()) {
                if (!importExportPlugin.hasUserData()) continue;
                importExportPlugin.importUserData(username, zipFile);
            }
            this.importLogger_.log(username);
            this.hservice_.openSession().clear();
        }
        catch (Exception ex) {
            this.orgService_.getUserHandler().removeUser(username, true);
            this.hservice_.openSession().clear();
            this.hservice_.closeSession();
            this.importLogger_.log(username, (Throwable)ex);
            this.log_.error((Object)("cann't import user " + username), (Throwable)ex);
        }
    }

    public void transformUserData() throws Exception {
        PageList plist = this.orgService_.getUserHandler().getUserPageList(50);
        for (int i = 1; i <= plist.getAvailablePage(); ++i) {
            List list = plist.getPage(i);
            for (int j = 0; j < list.size(); ++j) {
                User user = (User)list.get(j);
                String userName = user.getUserName();
                this.transformUserData(userName);
            }
        }
    }

    public void transformUserData(String username) throws Exception {
        String fileName = this.userTransformDir_ + username + ".zip";
        File file = new File(fileName);
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        this.transformUserData(username, out);
        out.close();
    }

    public void transformUserData(String username, ZipOutputStream os) throws Exception {
        try {
            for (ImportExportPlugin importExportPlugin : this.plugins_.values()) {
                if (!importExportPlugin.hasUserData()) continue;
                importExportPlugin.transformUserData(username, os);
            }
        }
        catch (Exception ex) {
            this.hservice_.closeSession();
            this.log_.error((Object)("Error when exporting the user" + username), (Throwable)ex);
        }
    }

    public void exportServiceData() throws Exception {
        for (String name : this.plugins_.keySet()) {
            this.exportServiceData(name);
        }
    }

    public void exportServiceData(String serviceName) throws Exception {
        ImportExportPlugin plugin = (ImportExportPlugin)this.plugins_.get(serviceName);
        if (!plugin.hasServiceData()) {
            return;
        }
        String fileName = this.serviceDataDir_ + serviceName + ".zip";
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(fileName));
        this.exportServiceData(serviceName, out);
        out.close();
    }

    public void exportServiceData(String serviceName, ZipOutputStream out) throws Exception {
        this.printMessage(" importing service " + serviceName + "...");
        ImportExportPlugin plugin = (ImportExportPlugin)this.plugins_.get(serviceName);
        if (!plugin.hasServiceData()) {
            return;
        }
        try {
            plugin.exportServiceData(out);
            this.hservice_.closeSession();
            this.exportLogger_.log(serviceName);
        }
        catch (Exception ex) {
            this.hservice_.closeSession();
            this.exportLogger_.log(serviceName, (Throwable)ex);
            this.log_.error((Object)("Cannot export service" + serviceName), (Throwable)ex);
        }
    }

    public void importServiceData() throws Exception {
        for (String name : this.plugins_.keySet()) {
            this.importServiceData(name);
        }
    }

    public void importServiceData(String serviceName) throws Exception {
        ImportExportPlugin plugin = (ImportExportPlugin)this.plugins_.get(serviceName);
        if (!plugin.hasServiceData()) {
            return;
        }
        String fileName = this.serviceDataDir_ + serviceName + ".zip";
        ZipFile zipFile = new ZipFile(new File(fileName));
        this.importServiceData(serviceName, zipFile);
        zipFile.close();
    }

    public void importServiceData(String serviceName, ZipFile zipFile) throws Exception {
        ImportExportPlugin plugin = (ImportExportPlugin)this.plugins_.get(serviceName);
        try {
            plugin.importServiceData(zipFile);
            this.importLogger_.log(serviceName);
        }
        catch (Exception ex) {
            this.importLogger_.log(serviceName, (Throwable)ex);
            this.hservice_.closeSession();
            this.log_.error((Object)("Cannot import the service " + serviceName), (Throwable)ex);
        }
    }

    public void transformServiceData() throws Exception {
        for (String name : this.plugins_.keySet()) {
            this.transformServiceData(name);
        }
    }

    public void transformServiceData(String serviceName) throws Exception {
        ImportExportPlugin plugin = (ImportExportPlugin)this.plugins_.get(serviceName);
        if (!plugin.hasServiceData()) {
            return;
        }
        String fileName = this.serviceTransformDir_ + serviceName + ".zip";
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(fileName));
        out.putNextEntry(new ZipEntry("metadata.xml"));
        out.write("junk data".getBytes());
        out.closeEntry();
        this.transformServiceData(serviceName, out);
        out.close();
    }

    public void transformServiceData(String serviceName, ZipOutputStream os) throws Exception {
        try {
            for (ImportExportPlugin importExportPlugin : this.plugins_.values()) {
                if (!importExportPlugin.hasServiceData()) continue;
                importExportPlugin.transformServiceData(os);
            }
        }
        catch (Exception ex) {
            this.hservice_.closeSession();
            this.log_.error((Object)("Cannot export service" + serviceName), (Throwable)ex);
        }
    }

    private void printMessage(String mesg) {
        if (!this.printMessage) {
            return;
        }
        System.out.println(mesg);
    }

    public ExportLogger getExportLogger() {
        return this.exportLogger_;
    }

    public ImportLogger getImportLogger() {
        return this.importLogger_;
    }
}

