/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.database.jdbc.CreateDBSchemaPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.naming.InitialContextInitializer;

public class DBSchemaCreator {
    public static String SQL_DELIMITER_COMMENT_PREFIX = "/*$DELIMITER:";
    public static String SQL_DELIMITER = ";";
    private static String SQL_ALREADYEXISTS = ".*((already exist)|(duplicate key)|(already used)|(ORA-00955))+.*";
    private final Pattern pattern;
    private static Log log = ExoLogger.getLogger((String)"database.DBSchemaCreator");
    private List<CreateDBSchemaPlugin> createDBSchemaPlugins = new ArrayList<CreateDBSchemaPlugin>();

    public DBSchemaCreator(InitialContextInitializer contextInit) {
        this.pattern = Pattern.compile(SQL_ALREADYEXISTS, 2);
    }

    private DBSchemaCreator(String dsName, String script) throws SQLException, NamingException {
        this.pattern = Pattern.compile(SQL_ALREADYEXISTS, 2);
        this.createTables(dsName, script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables(String dsName, String script) throws NamingException, SQLException {
        InitialContext context = new InitialContext();
        DataSource ds = (DataSource)context.lookup(dsName);
        Connection conn = ds.getConnection();
        String sql = "";
        try {
            String[] scripts = null;
            if (script.startsWith(SQL_DELIMITER_COMMENT_PREFIX)) {
                try {
                    String s = script.substring(SQL_DELIMITER_COMMENT_PREFIX.length());
                    int endOfDelimIndex = s.indexOf("*/");
                    String delim = s.substring(0, endOfDelimIndex).trim();
                    s = s.substring(endOfDelimIndex + 2).trim();
                    scripts = s.split(delim);
                }
                catch (IndexOutOfBoundsException e) {
                    log.warn((Object)("Error of parse SQL-script file. Invalid DELIMITER configuration. Valid format is '" + SQL_DELIMITER_COMMENT_PREFIX + "XXX*/' at begin of the SQL-script file, where XXX - DELIMITER string." + " Spaces will be trimed. "), (Throwable)e);
                    log.info((Object)("Using DELIMITER:[" + SQL_DELIMITER + "]"));
                    scripts = script.split(SQL_DELIMITER);
                }
            } else {
                scripts = script.split(SQL_DELIMITER);
            }
            for (String scr : scripts) {
                String s = DBSchemaCreator.cleanWhitespaces(scr.trim());
                if (s.length() <= 0) continue;
                sql = s;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Execute script: \n[" + sql + "]"));
                }
                try {
                    conn.setAutoCommit(false);
                    conn.createStatement().executeUpdate(sql);
                    conn.commit();
                }
                catch (SQLException e) {
                    conn.rollback();
                    Matcher aeMatcher = this.pattern.matcher(e.getMessage().trim());
                    if (!aeMatcher.matches()) {
                        throw e;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)e.getMessage());
                }
            }
            log.info((Object)("DB schema of DataSource: '" + dsName + "' created succesfully. context " + context));
        }
        catch (SQLException e) {
            SQLException next = e.getNextException();
            String errorTrace = "";
            while (next != null) {
                errorTrace = errorTrace + next.getMessage() + "; ";
                next = e.getNextException();
            }
            Throwable cause = e.getCause();
            log.error((Object)("Could not create db schema of DataSource: '" + dsName + "'. Reason: " + e.getMessage() + "; " + errorTrace + (cause != null ? " (Cause: " + cause.getMessage() + ")" : "") + ". Last command: " + sql));
            e.printStackTrace();
        }
        finally {
            conn.close();
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof CreateDBSchemaPlugin) {
            CreateDBSchemaPlugin csplugin = (CreateDBSchemaPlugin)plugin;
            try {
                this.createTables(csplugin.getDataSource(), csplugin.getScript());
                this.createDBSchemaPlugins.add(csplugin);
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public ComponentPlugin removePlugin(String name) {
        return null;
    }

    public Collection getPlugins() {
        return this.createDBSchemaPlugins;
    }

    public static DBSchemaCreator initialize(String dsName, String script) throws SQLException, NamingException {
        return new DBSchemaCreator(dsName, script);
    }

    public static String cleanWhitespaces(String string) {
        if (string != null) {
            char[] cc = string.toCharArray();
            for (int ci = cc.length - 1; ci > 0; --ci) {
                if (!Character.isWhitespace(cc[ci])) continue;
                cc[ci] = 32;
            }
            return new String(cc);
        }
        return string;
    }
}

