/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.templates.groovy;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.exoplatform.services.templates.groovy.GroovyTemplateLoader;

public class GroovyTemplateFileLoader
extends GroovyTemplateLoader {
    private String[] basePath_;

    public GroovyTemplateFileLoader(String basePath) {
        String[] tmp = new String[]{basePath};
        this.init(tmp);
    }

    public GroovyTemplateFileLoader(String[] basePath) {
        this.init(basePath);
    }

    private void init(String[] basePath) {
        this.basePath_ = new String[basePath.length];
        for (int i = 0; i < basePath.length; ++i) {
            this.basePath_[i] = !basePath[i].endsWith("/") ? basePath[i] + "/" : basePath[i];
        }
    }

    public boolean canLoad(String type, String template) throws Exception {
        int i;
        if ((type == null || "file".equals(type)) && (i = 0) < this.basePath_.length) {
            String realPath = this.basePath_[i] + template;
            File file = new File(realPath);
            return file.exists();
        }
        return false;
    }

    public InputStream load(String template) throws Exception {
        for (int i = 0; i < this.basePath_.length; ++i) {
            String realPath = this.basePath_[i] + template;
            File file = new File(realPath);
            if (!file.exists()) continue;
            FileInputStream is = new FileInputStream(file);
            byte[] buf = new byte[is.available()];
            is.read(buf);
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            return bis;
        }
        return null;
    }
}

