/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.templates.groovy.impl;

import groovy.lang.Writable;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.templates.groovy.GroovyTemplateLoader;
import org.exoplatform.services.templates.groovy.GroovyTemplateService;
import org.exoplatform.services.templates.groovy.TemplateNotFoundException;

public class GroovyTemplateServiceImpl
implements GroovyTemplateService {
    static TemplateLoaderPriorityComparator LOADER_COMPARATOR = new TemplateLoaderPriorityComparator();
    private SimpleTemplateEngine engine_ = new SimpleTemplateEngine();
    private List<GroovyTemplateLoader> templateLoader_ = new ArrayList<GroovyTemplateLoader>();
    private ExoCache templatesCache_;
    private boolean cacheTemplate_ = true;

    public GroovyTemplateServiceImpl(InitParams params, CacheService cservice) throws Exception {
        this.templatesCache_ = cservice.getCacheInstance(GroovyTemplateService.class.getName());
        this.cacheTemplate_ = "true".equals(params.getValueParam("cache.template").getValue());
    }

    public void addTemplateLoader(ComponentPlugin plugin) {
        GroovyTemplateLoader loader = (GroovyTemplateLoader)plugin;
        this.addTemplateLoader(loader);
    }

    public synchronized void addTemplateLoader(GroovyTemplateLoader loader) {
        this.templateLoader_.add(loader);
        Collections.sort(this.templateLoader_, LOADER_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String merge(String type, String name, Map binding) throws TemplateNotFoundException, Exception {
        try {
            String s;
            Template template = this.getTemplate(type, name);
            if (template == null) {
                throw new Exception("Cannot  find the template " + template);
            }
            binding.put("service", this);
            binding.put("binding", binding);
            String string = s = template.make(binding).toString();
            return string;
        }
        finally {
            binding.remove("service");
            binding.remove("binding");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Writer writer, String type, String tname, Map binding) throws TemplateNotFoundException, Exception {
        try {
            Template template = this.getTemplate(type, tname);
            binding.put("service", this);
            binding.put("binding", binding);
            Writable writable = template.make(binding);
            writable.writeTo(writer);
        }
        finally {
            binding.remove("service");
            binding.remove("binding");
        }
    }

    public String include(String name, Map binding) throws TemplateNotFoundException, Exception {
        HashMap newBinding = new HashMap();
        if (binding != null) {
            newBinding.putAll(binding);
        }
        Template template = this.getTemplate(null, name);
        return template.make(binding).toString();
    }

    public String include(String type, String name, Map binding) throws TemplateNotFoundException, Exception {
        HashMap newBinding = new HashMap();
        if (binding != null) {
            newBinding.putAll(binding);
        }
        Template template = this.getTemplate(type, name);
        return template.make(binding).toString();
    }

    private Template getTemplate(String type, String name) throws TemplateNotFoundException, Exception {
        Template template = (Template)this.templatesCache_.get((Serializable)((Object)name));
        if (template != null) {
            return template;
        }
        for (GroovyTemplateLoader loader : this.templateLoader_) {
            if (!loader.canLoad(type, name)) continue;
            InputStream is = loader.load(name);
            byte[] buf = new byte[is.available()];
            is.read(buf);
            String text = new String(buf);
            template = this.engine_.createTemplate(text);
            if (!this.cacheTemplate_) continue;
            this.templatesCache_.put((Serializable)((Object)name), (Object)template);
        }
        if (template == null) {
            throw new TemplateNotFoundException("Cannot find template " + name);
        }
        return template;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TemplateLoaderPriorityComparator
    implements Comparator<GroovyTemplateLoader> {
        @Override
        public int compare(GroovyTemplateLoader loader1, GroovyTemplateLoader loader2) {
            return loader1.getPriority() - loader2.getPriority();
        }
    }
}

