/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.templates.velocity.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.ResourceManager;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.templates.velocity.ResourceLoaderPlugin;
import org.exoplatform.services.templates.velocity.StaticResourceLoader;
import org.exoplatform.services.templates.velocity.impl.StaticResourceLoaderImpl;

public class ResourceManagerImpl
implements ResourceManager {
    public static final int RESOURCE_TEMPLATE = 1;
    public static final int RESOURCE_CONTENT = 2;
    protected RuntimeServices rsvc = null;
    private StaticResourceLoaderImpl staticResLoader_;
    private List plugins_ = new ArrayList();

    public ResourceManagerImpl(StaticResourceLoaderImpl floader) throws Exception {
        this.staticResLoader_ = floader;
    }

    public void initialize(RuntimeServices rs) throws Exception {
        this.rsvc = rs;
        this.staticResLoader_.setRuntimeServices(rs);
        this.rsvc.info((Object)("Default ResourceManager initializing. (" + this.getClass() + ")"));
        this.rsvc.info((Object)"Default ResourceManager initialization complete.");
    }

    public Resource getResource(String resourceName, int resourceType, String encoding) throws ResourceNotFoundException, ParseErrorException, Exception {
        for (int i = 0; i < this.plugins_.size(); ++i) {
            ResourceLoaderPlugin plugin = (ResourceLoaderPlugin)this.plugins_.get(i);
            if (!plugin.canLoadResource(resourceName)) continue;
            return plugin.getResource(resourceName, resourceType, encoding);
        }
        return this.staticResLoader_.getResource(resourceName, resourceType, encoding);
    }

    public Resource getResource(String resourceName, int resourceType) throws ResourceNotFoundException, ParseErrorException, Exception {
        return this.getResource(resourceName, resourceType, "ISO-8859-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLoaderNameForResource(String resourceName) {
        Object plugin;
        StaticResourceLoaderImpl resourceLoader = null;
        for (int i = 0; i < this.plugins_.size(); ++i) {
            plugin = (ResourceLoaderPlugin)this.plugins_.get(i);
            if (!plugin.canLoadResource(resourceName)) continue;
            resourceLoader = plugin;
        }
        if (resourceLoader == null) {
            resourceLoader = this.staticResLoader_;
        }
        InputStream is = null;
        try {
            is = resourceLoader.getResourceStream(resourceName);
            if (is != null) {
                plugin = ((Object)((Object)resourceLoader)).getClass().toString();
                return plugin;
            }
        }
        catch (ResourceNotFoundException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    public void addPlugin(ComponentPlugin plugin) {
        ResourceLoaderPlugin loader = (ResourceLoaderPlugin)plugin;
        loader.setRuntimeServices(this.rsvc);
        this.plugins_.add(loader);
    }

    public StaticResourceLoader getStaticResourceLoader() {
        return this.staticResLoader_;
    }
}

