/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.community.CommunityConfigService;
import org.exoplatform.portal.community.CommunityNavigation;
import org.exoplatform.portal.community.CommunityPortal;
import org.exoplatform.portal.config.Interceptor;
import org.exoplatform.portal.config.PortalACL;
import org.exoplatform.portal.config.impl.NodeImpl;
import org.exoplatform.portal.config.impl.NodeNavigationData;
import org.exoplatform.portal.config.impl.PageData;
import org.exoplatform.portal.config.impl.PortalConfigData;
import org.exoplatform.portal.config.impl.UserConfigTemplate;
import org.exoplatform.portal.config.model.Node;
import org.exoplatform.portal.config.model.NodeNavigation;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.database.HibernateService;
import org.hibernate.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPortalServiceInterceptor
implements Interceptor {
    static CommunityNavigationComparator COMPARATOR = new CommunityNavigationComparator();
    private HibernateService hservice_;
    private CommunityConfigService communityService_;
    private UserConfigTemplate userConfigTemp_;
    private PortalACL portalACL_;

    public DefaultPortalServiceInterceptor(HibernateService hservice, CommunityConfigService communityService, PortalACL portalACL) throws Exception {
        this.hservice_ = hservice;
        this.communityService_ = communityService;
        this.userConfigTemp_ = (UserConfigTemplate)PortalContainer.getInstance().getComponentInstanceOfType(UserConfigTemplate.class);
        this.portalACL_ = portalACL;
    }

    @Override
    public PortalConfig getPortalConfig(String owner) throws Exception {
        PortalConfigData data;
        CommunityPortal cp = this.communityService_.findCommunityPortal(owner);
        String portalOwner = owner;
        boolean shared = false;
        if (cp != null && !cp.getPortal().equals("#{owner}")) {
            portalOwner = cp.getPortal();
            shared = true;
        }
        if ((data = (PortalConfigData)this.hservice_.findOne(PortalConfigData.class, (Serializable)((Object)portalOwner))) == null) {
            this.userConfigTemp_.createConfigurationForUser(portalOwner);
            data = (PortalConfigData)this.hservice_.findOne(PortalConfigData.class, (Serializable)((Object)portalOwner));
        }
        PortalConfig config = (PortalConfig)data.getPortalConfig().softCloneObject();
        if (shared) {
            config.setOwner(owner);
            config.setEditPermission(null);
            config.setSharedLayout(true);
        }
        return config;
    }

    @Override
    public void savePortalConfig(PortalConfig config) throws Exception {
        Session session = this.hservice_.openSession();
        PortalConfigData data = (PortalConfigData)session.get(PortalConfigData.class, (Serializable)((Object)config.getOwner()));
        if (data == null) {
            session.save((Object)new PortalConfigData(config));
        } else {
            data.setPortalConfig(config);
            session.update((Object)data);
        }
        session.flush();
    }

    @Override
    public Page getPage(String pageId, String remoteUser) throws Exception {
        PageData data = (PageData)this.hservice_.findOne(PageData.class, (Serializable)((Object)pageId));
        if (data == null) {
            return null;
        }
        if (!this.portalACL_.hasViewPagePermission(data.getPage(), remoteUser)) {
            return null;
        }
        return data.getPage();
    }

    @Override
    public void savePage(Page page) throws Exception {
        Session session = this.hservice_.openSession();
        PageData data = (PageData)session.get(PageData.class, (Serializable)((Object)page.getPageId()));
        if (data == null) {
            session.save((Object)new PageData(page));
        } else {
            data.setPage(page);
            session.update((Object)data);
        }
        session.flush();
    }

    @Override
    public Node getNodeNavigation(String owner, String remoteUser) throws Exception {
        try {
            List children;
            NodeNavigationData data = (NodeNavigationData)this.hservice_.findOne(NodeNavigationData.class, (Serializable)((Object)owner));
            if (data == null) {
                this.userConfigTemp_.createConfigurationForUser(owner);
                data = (NodeNavigationData)this.hservice_.findOne(NodeNavigationData.class, (Serializable)((Object)owner));
            }
            PageNode pnode = data.getNodeNavigation().getNode();
            NodeImpl root = new NodeImpl(pnode, null, 0);
            List list = this.communityService_.findCommunityNavigation(owner);
            Collections.sort(list, COMPARATOR);
            ArrayList<Node> invisibleNodes = new ArrayList<Node>();
            for (int i = 0; i < list.size(); ++i) {
                CommunityNavigation cn = (CommunityNavigation)list.get(i);
                data = (NodeNavigationData)this.hservice_.findOne(NodeNavigationData.class, (Serializable)((Object)cn.getNavigation()));
                if (data == null) continue;
                PageNode sharedNode = data.getNodeNavigation().getNode();
                children = sharedNode.getChildren();
                for (int j = 0; j < children.size(); ++j) {
                    PageNode pageChild = (PageNode)children.get(j);
                    NodeImpl shareChild = new NodeImpl(pageChild, (Node)root, 1);
                    shareChild.setShare(true);
                    shareChild.setGroupId(cn.getGroupId());
                    this.getInvisibleNode(invisibleNodes, shareChild, cn.getNavigation(), remoteUser);
                    root.addChild(shareChild);
                }
            }
            CommunityPortal cp = this.communityService_.findCommunityPortal(owner);
            if (cp != null && cp.getUseDefaultHomePage()) {
                data = (NodeNavigationData)this.hservice_.findOne(NodeNavigationData.class, (Serializable)((Object)cp.getPortal()));
                root.setPageReference(data.getNodeNavigation().getNode().getPageReference());
            }
            this.getInvisibleNode(invisibleNodes, root, owner, remoteUser);
            for (Node ele : invisibleNodes) {
                if (ele.getParent() == null) {
                    ele.getChildren().clear();
                    continue;
                }
                children = ele.getParent().getChildren();
                if (children == null) continue;
                children.remove(ele);
            }
            return root;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private void getInvisibleNode(List<Node> values, Node node, String owner, String remoteUser) throws Exception {
        if (node.getViewPermission() != null && !this.portalACL_.hasViewNodePermission(node, owner, remoteUser)) {
            node.setInvisible(true);
            if (!values.contains(node)) {
                values.add(node);
            }
            return;
        }
        List children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            NodeImpl child = (NodeImpl)children.get(i);
            this.getInvisibleNode(values, child, owner, remoteUser);
        }
    }

    @Override
    public void saveNodeNavigation(String owner, Node node) throws Exception {
        NodeImpl root = (NodeImpl)node;
        PageNode prootNode = this.createPageNode(root);
        Session session = this.hservice_.openSession();
        NodeNavigationData data = (NodeNavigationData)session.get(NodeNavigationData.class, (Serializable)((Object)owner));
        if (data == null) {
            session.save((Object)new NodeNavigationData(owner, prootNode));
        } else {
            NodeNavigation nn = new NodeNavigation();
            nn.setOwner(owner);
            nn.setNode(prootNode);
            data.setNodeNavigation(nn);
            session.update((Object)data);
        }
        session.flush();
    }

    private PageNode createPageNode(NodeImpl node) {
        PageNode pnode = new PageNode();
        pnode.setUri(node.getUri());
        pnode.setName(node.getName());
        pnode.setViewPermission(node.getViewPermission());
        pnode.setEditPermission(node.getEditPermission());
        pnode.setIcon(node.getIcon());
        pnode.setLabel(node.getLabel());
        pnode.setDescription(node.getDescription());
        pnode.setCreator(node.getCreator());
        pnode.setModifier(node.getModifier());
        pnode.setInvisible(node.isInvisible());
        pnode.setPageReference(node.getPageReference());
        for (int i = 0; i < node.getChildrenSize(); ++i) {
            NodeImpl child = (NodeImpl)node.getChild(i);
            if (child.isShare()) continue;
            pnode.getChildren().add(this.createPageNode(child));
        }
        return pnode;
    }

    static class CommunityNavigationComparator
    implements Comparator {
        CommunityNavigationComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            CommunityNavigation cn1 = (CommunityNavigation)obj1;
            CommunityNavigation cn2 = (CommunityNavigation)obj2;
            return cn1.getPriority() - cn2.getPriority();
        }
    }
}

