/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.exoplatform.commons.utils.ExpressionUtil;
import org.exoplatform.portal.config.model.Node;
import org.exoplatform.portal.config.model.NodeVisitor;
import org.exoplatform.portal.config.model.PageNode;

public class NodeImpl
extends PageNode
implements Node,
Cloneable {
    private transient Node parent;
    transient String resolvedLabel_;
    private transient int level;
    transient boolean selected;
    transient boolean expanded_ = false;
    transient boolean share = false;
    transient String groupId;

    public NodeImpl() {
    }

    public NodeImpl(String uri, String name, String label) {
        this.uri = uri;
        this.name = name;
        this.label = label;
    }

    public NodeImpl(Node nodeImpl, Node parent, int level) {
        this.copyPageNode((PageNode)((Object)nodeImpl));
        this.parent = parent;
        this.level = level;
        this.selected = nodeImpl.isSelectedPath();
        this.share = nodeImpl.isShare();
        this.groupId = nodeImpl.getGroupId();
        this.resolvedLabel_ = nodeImpl.getResolvedLabel();
        List list = nodeImpl.getChildren();
        if (list != null) {
            this.children = new ArrayList(3);
            for (int i = 0; i < list.size(); ++i) {
                nodeImpl = (NodeImpl)list.get(i);
                NodeImpl childNode = new NodeImpl(nodeImpl, (Node)this, level + 1);
                this.children.add(childNode);
            }
        }
    }

    public NodeImpl(PageNode pageNode, Node parent, int level) {
        this.copyPageNode(pageNode);
        this.parent = parent;
        this.level = level;
        this.selected = false;
        List list = pageNode.getChildren();
        if (list != null) {
            this.children = new ArrayList(3);
            for (int i = 0; i < list.size(); ++i) {
                pageNode = (PageNode)list.get(i);
                NodeImpl childNode = new NodeImpl(pageNode, (Node)this, level + 1);
                this.children.add(childNode);
            }
        }
    }

    private void copyPageNode(PageNode node) {
        this.uri = node.getUri();
        this.name = node.getName();
        this.label = node.getLabel();
        this.viewPermission = node.getViewPermission();
        this.editPermission = node.getEditPermission();
        this.icon = node.getIcon();
        this.pageReference = node.getPageReference();
        this.description = node.getDescription();
        this.creator = node.getCreator();
        this.modifier = node.getModifier();
        this.invisible = node.isInvisible();
    }

    public void setLabel(String s) {
        super.setLabel(s);
        this.resolvedLabel_ = s;
    }

    public String getResolvedLabel() {
        return this.resolvedLabel_;
    }

    public void setResolvedLabel(ResourceBundle res) {
        this.resolvedLabel_ = ExpressionUtil.getExpressionValue((ResourceBundle)res, (String)this.label);
        if (this.resolvedLabel_ == null) {
            this.resolvedLabel_ = this.getName();
        }
    }

    public boolean isShare() {
        return this.share;
    }

    public void setShare(boolean b) {
        this.share = b;
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            NodeImpl child = (NodeImpl)this.children.get(i);
            child.setShare(b);
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            NodeImpl child = (NodeImpl)this.children.get(i);
            child.setGroupId(groupId);
        }
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public Node getParent() {
        return this.parent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int i) {
        this.level = i;
    }

    public void setSelectedPath(boolean b) {
        this.selected = b;
        if (this.parent != null) {
            this.parent.setSelectedPath(b);
        }
    }

    public boolean isSelectedPath() {
        return this.selected;
    }

    public boolean isExpanded() {
        return this.expanded_;
    }

    public void setExpanded(boolean b) {
        this.expanded_ = b;
    }

    public Node getChild(int pos) {
        if (pos >= this.children.size()) {
            return null;
        }
        return (Node)this.children.get(pos);
    }

    public void addChild(Node node) {
        node.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList(3);
        }
        this.children.add(node);
    }

    public Node removeChild(int pos) {
        if (pos >= this.children.size()) {
            return null;
        }
        NodeImpl node = (NodeImpl)this.children.remove(pos);
        node.setParent(null);
        return node;
    }

    public Node removeChild(String uri) {
        if (this.children == null) {
            return null;
        }
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            NodeImpl child = (NodeImpl)i.next();
            if (!child.getUri().equals(uri)) continue;
            i.remove();
            child.setParent(null);
            return child;
        }
        return null;
    }

    public int getChildrenSize() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public Node findNode(String uri) {
        if (this.uri.equals(uri)) {
            return this;
        }
        if (this.children == null) {
            return null;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = (Node)this.children.get(i);
            Node result = child.findNode(uri);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean hasChild(String name) {
        if (this.children == null) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            NodeImpl child = (NodeImpl)this.children.get(i);
            if (!name.equals(child.getName())) continue;
            return true;
        }
        return false;
    }

    public NodeImpl getThisNode() {
        return this;
    }

    public void visit(NodeVisitor visitor) {
        visitor.visit(this);
        if (this.children != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                NodeImpl child = (NodeImpl)this.children.get(i);
                child.visit(visitor);
            }
        }
    }

    public Node cloneNode() {
        return new NodeImpl(this, null, 0);
    }
}

