/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl;

import org.exoplatform.portal.config.impl.PageDescriptionData;
import org.exoplatform.portal.config.impl.PortalConfigServiceImpl;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.Permission;

public class PageData
extends PageDescriptionData {
    private transient Page page_;

    public PageData() {
    }

    public PageData(Page page) throws Exception {
        this.setPage(page);
    }

    public PageData(String xml) throws Exception {
        this.setData(xml);
    }

    public String getData() throws Exception {
        String xml = PortalConfigServiceImpl.toXML(this.page_);
        return xml;
    }

    public void setData(String s) throws Exception {
        this.page_ = (Page)PortalConfigServiceImpl.fromXML(s, Page.class);
        this.owner_ = this.page_.getOwner();
        this.name_ = this.page_.getName();
        this.title_ = this.page_.getTitle();
        this.id_ = PageData.getId(this.page_);
        Permission perm = this.page_.getViewPermission();
        if (perm != null) {
            this.viewPermission_ = perm.toString();
        }
        if ((perm = this.page_.getEditPermission()) != null) {
            this.editPermission_ = perm.toString();
        }
    }

    public Page getPage() {
        return this.page_;
    }

    public void setPage(Page obj) {
        this.page_ = obj;
        this.owner_ = this.page_.getOwner();
        this.name_ = this.page_.getName();
        this.title_ = this.page_.getTitle();
        this.id_ = this.page_.getPageId();
        Permission perm = this.page_.getViewPermission();
        if (perm != null) {
            this.viewPermission_ = perm.toString();
        } else {
            this.editPermission_ = null;
        }
        perm = this.page_.getEditPermission();
        this.editPermission_ = perm != null ? perm.toString() : null;
    }

    public static String getId(Page page) {
        return page.getOwner() + ":" + page.getName();
    }
}

