/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl;

import org.apache.commons.logging.Log;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.portal.config.ExoPortletPreferencesPersister;
import org.exoplatform.portal.config.impl.PortalConfigServiceImpl;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.Portlet;
import org.exoplatform.portal.config.model.PortletPreferences;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.portletcontainer.pci.ExoWindowID;
import org.exoplatform.services.portletcontainer.pci.WindowID;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.persistence.PortletPreferencesPersister;

public class PortletPreferencesPersisterImpl
implements PortletPreferencesPersister,
ExoPortletPreferencesPersister {
    private transient PortalConfigServiceImpl service_;
    private transient Log log_;

    public PortletPreferencesPersisterImpl(PortalConfigServiceImpl impl, LogService lservice) {
        this.service_ = impl;
        this.log_ = lservice.getLog(this.getClass());
    }

    public ExoPortletPreferences getPortletPreferences(WindowID windowID) throws Exception {
        SessionContainer scontainer = SessionContainer.getInstance();
        Portlet portlet = this.findPortlet(windowID, scontainer.getRemoteUser());
        if (portlet != null && portlet.getPortletPreferences() != null) {
            return portlet.getPortletPreferences().toExoPortletPreferences();
        }
        return null;
    }

    public void savePortletPreferences(WindowID windowID, ExoPortletPreferences exoPref) throws Exception {
        ExoWindowID exoWindowID = (ExoWindowID)windowID;
        String configurationSource = exoWindowID.getConfigurationSource();
        Container layout = null;
        PortalConfig config = null;
        SessionContainer scontainer = SessionContainer.getInstance();
        if ("default-portal-config".equals(configurationSource)) {
            config = this.service_.getPortalConfig(windowID.getOwner(), scontainer.getRemoteUser());
            layout = config.getLayout();
        } else if ("default-portal-config".equals(configurationSource)) {
            config = this.service_.getPortalConfig(windowID.getOwner(), scontainer.getRemoteUser());
            layout = config.getMobilePortalLayout();
        } else {
            layout = this.service_.getPage(configurationSource, scontainer.getRemoteUser());
        }
        Portlet portlet = layout.findPortletByWindowId(exoWindowID.getPersistenceId());
        if (portlet == null) {
            this.log_.error((Object)("cannot find the portlet, portlet persitence id: " + exoWindowID.getPersistenceId()));
            throw new Exception("Cannot find the portlet in  " + configurationSource);
        }
        PortletPreferences newprefs = new PortletPreferences(exoPref);
        portlet.setPortletPreferences(newprefs);
        newprefs.setModifier(scontainer.getRemoteUser());
        if (portlet.getPortletPreferences() != null) {
            newprefs.setCreator(portlet.getPortletPreferences().getCreator());
        } else {
            newprefs.setCreator(scontainer.getRemoteUser());
        }
        if (config != null) {
            this.service_.savePortalConfig(config, scontainer.getRemoteUser());
        } else {
            this.service_.savePage((Page)layout, scontainer.getRemoteUser());
        }
    }

    public PortletPreferences getPortletPreferencesData(WindowID windowID) throws Exception {
        SessionContainer scontainer = SessionContainer.getInstance();
        Portlet portlet = this.findPortlet(windowID, scontainer.getRemoteUser());
        if (portlet != null && portlet.getPortletPreferences() != null) {
            return portlet.getPortletPreferences();
        }
        return null;
    }

    public void savePortletPreferencesData(WindowID windowID, PortletPreferences prefs) throws Exception {
    }

    private Portlet findPortlet(WindowID windowID, String remoteUser) throws Exception {
        ExoWindowID exoWindowID = (ExoWindowID)windowID;
        String configurationSource = exoWindowID.getConfigurationSource();
        Container layout = null;
        PortalConfig config = null;
        if ("default-portal-config".equals(configurationSource)) {
            config = this.service_.getPortalConfig(windowID.getOwner(), remoteUser);
            layout = config.getLayout();
        } else if ("default-portal-config".equals(configurationSource)) {
            config = this.service_.getPortalConfig(windowID.getOwner(), remoteUser);
            layout = config.getMobilePortalLayout();
        } else {
            layout = this.service_.getPage(configurationSource, remoteUser);
        }
        return layout.findPortletByWindowId(exoWindowID.getPersistenceId());
    }
}

