/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.impl;

import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.impl.NewPortalConfig;
import org.exoplatform.portal.config.impl.NodeNavigationData;
import org.exoplatform.portal.config.impl.PageData;
import org.exoplatform.portal.config.impl.PortalConfigData;
import org.exoplatform.portal.config.impl.PortalConfigServiceImpl;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageSet;
import org.exoplatform.services.database.HibernateService;
import org.hibernate.Session;

public class UserConfigTemplate {
    private String templateConfig_;
    private String templatePageSet_;
    private String templateNavigation_;
    private NewPortalConfig config_;
    private ConfigurationManager cservice_;
    private HibernateService hservice_;

    public UserConfigTemplate(HibernateService hservice, ConfigurationManager cservice, InitParams params) throws Exception {
        this.cservice_ = cservice;
        this.hservice_ = hservice;
        this.config_ = (NewPortalConfig)params.getObjectParamValues(NewPortalConfig.class).get(0);
        String templateUser = this.config_.getTemplateUser();
        String templateLoc = this.config_.getTemplateLocation();
        InputStream is = this.cservice_.getInputStream(templateLoc + "/" + templateUser + "-config.xml");
        this.templateConfig_ = IOUtil.getStreamContentAsString((InputStream)is);
        is = this.cservice_.getInputStream(templateLoc + "/" + templateUser + "-pages.xml");
        this.templatePageSet_ = IOUtil.getStreamContentAsString((InputStream)is);
        is = this.cservice_.getInputStream(templateLoc + "/" + templateUser + "-navigation.xml");
        this.templateNavigation_ = IOUtil.getStreamContentAsString((InputStream)is);
    }

    public void createConfigurationForUser(String owner) throws Exception {
        String config = null;
        String pageSet = null;
        String navigation = null;
        if (this.config_.isPredefinedUser(owner)) {
            String location = this.config_.getTemplateLocation();
            config = IOUtil.getStreamContentAsString((InputStream)this.cservice_.getInputStream(location + "/" + owner + "-config.xml"));
            pageSet = IOUtil.getStreamContentAsString((InputStream)this.cservice_.getInputStream(location + "/" + owner + "-pages.xml"));
            navigation = IOUtil.getStreamContentAsString((InputStream)this.cservice_.getInputStream(location + "/" + owner + "-navigation.xml"));
        } else {
            config = StringUtils.replace((String)this.templateConfig_, (String)"@owner@", (String)owner);
            pageSet = StringUtils.replace((String)this.templatePageSet_, (String)"@owner@", (String)owner);
            navigation = StringUtils.replace((String)this.templateNavigation_, (String)"@owner@", (String)owner);
        }
        Session session = this.hservice_.openSession();
        session.save((Object)new PortalConfigData(config));
        session.save((Object)new NodeNavigationData(navigation));
        PageSet ps = (PageSet)PortalConfigServiceImpl.fromXML(pageSet, PageSet.class);
        List pages = ps.getPages();
        for (int i = 0; i < pages.size(); ++i) {
            Page page = (Page)pages.get(i);
            session.save((Object)new PageData(page));
        }
        session.flush();
    }
}

