/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.helper;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.exoplatform.services.portletcontainer.pci.model.CustomWindowState;
import org.exoplatform.services.portletcontainer.pci.model.Supports;

public abstract class BasePortletURL
implements PortletURL {
    private List supports;
    private String markup;
    protected Enumeration supportedWindowState;
    protected List customWindowStates;
    protected WindowState requiredWindowState;
    protected PortletMode requiredPortletMode;
    protected Map parameters = new HashMap();
    protected boolean isSecure;
    protected boolean setSecureCalled;
    protected String type;
    protected boolean isCurrentlySecured;

    public BasePortletURL(String type, String markup, List supports, boolean isCurrentlySecured, List customWindowStates, Enumeration supportedWindowState) {
        this.type = type;
        this.markup = markup;
        this.supports = supports;
        this.isCurrentlySecured = isCurrentlySecured;
        this.customWindowStates = customWindowStates;
        this.supportedWindowState = supportedWindowState;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (windowState == null) {
            throw new WindowStateException("The portlet mode is null", windowState);
        }
        if (windowState == WindowState.NORMAL || windowState == WindowState.MINIMIZED || windowState == WindowState.MAXIMIZED) {
            this.requiredWindowState = windowState;
            return;
        }
        while (this.supportedWindowState.hasMoreElements()) {
            WindowState state = (WindowState)this.supportedWindowState.nextElement();
            if (!state.toString().equals(windowState.toString())) continue;
            for (CustomWindowState customState : this.customWindowStates) {
                if (!customState.getWindowState().equals(windowState.toString())) continue;
                this.requiredWindowState = windowState;
                return;
            }
        }
        throw new WindowStateException("The window state " + windowState.toString() + " is not supported by the portlet container", windowState);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (portletMode == null) {
            throw new PortletModeException("The portlet mode is null", portletMode);
        }
        if (portletMode == PortletMode.VIEW) {
            this.requiredPortletMode = portletMode;
            return;
        }
        boolean supported = false;
        block0: for (Supports sp : this.supports) {
            if (!this.markup.equals(sp.getMimeType())) continue;
            List modeList = sp.getPortletMode();
            for (String modeString : modeList) {
                if (modeString == null || !modeString.equalsIgnoreCase(portletMode.toString())) continue;
                supported = true;
                break block0;
            }
        }
        if (!supported) {
            throw new PortletModeException("The mode " + portletMode.toString() + " is not supported by that portlet", portletMode);
        }
        this.requiredPortletMode = portletMode;
    }

    public void setParameter(String s, String s1) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (s1 == null) {
            throw new IllegalArgumentException("the value given is null");
        }
        this.parameters.put(s, s1);
    }

    public void setParameter(String s, String[] strings) {
        if (s == null) {
            throw new IllegalArgumentException("the key given is null");
        }
        if (strings == null) {
            throw new IllegalArgumentException("the value given is null");
        }
        this.parameters.put(s, strings);
    }

    public void setParameters(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("the map given is null");
        }
        if (map.containsKey(null)) {
            throw new IllegalArgumentException("the map given contains a null key");
        }
        Set keys = map.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            if (iter.next() instanceof String) continue;
            throw new IllegalArgumentException("the map contains a non String key");
        }
        Collection values = map.values();
        Iterator iter2 = values.iterator();
        while (iter2.hasNext()) {
            if (iter2.next() instanceof String[]) continue;
            throw new IllegalArgumentException("the map contains a non String[] value");
        }
        this.parameters = map;
    }

    public Object getParameter(String key) {
        return this.parameters.get(key);
    }

    public void setSecure(boolean b) throws PortletSecurityException {
        this.isSecure = b;
        this.setSecureCalled = true;
    }

    public abstract String toString();
}

