/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.portletcontainer.pci.model;

import java.io.InputStream;
import java.util.Iterator;
import javax.portlet.PortletMode;
import org.exoplatform.commons.xml.ExoXPPParser;
import org.exoplatform.services.portletcontainer.pci.model.CustomPortletMode;
import org.exoplatform.services.portletcontainer.pci.model.CustomWindowState;
import org.exoplatform.services.portletcontainer.pci.model.Description;
import org.exoplatform.services.portletcontainer.pci.model.DisplayName;
import org.exoplatform.services.portletcontainer.pci.model.ExoPortletPreferences;
import org.exoplatform.services.portletcontainer.pci.model.Filter;
import org.exoplatform.services.portletcontainer.pci.model.InitParam;
import org.exoplatform.services.portletcontainer.pci.model.Portlet;
import org.exoplatform.services.portletcontainer.pci.model.PortletApp;
import org.exoplatform.services.portletcontainer.pci.model.PortletCollection;
import org.exoplatform.services.portletcontainer.pci.model.PortletInfo;
import org.exoplatform.services.portletcontainer.pci.model.Preference;
import org.exoplatform.services.portletcontainer.pci.model.SecurityConstraint;
import org.exoplatform.services.portletcontainer.pci.model.SecurityRoleRef;
import org.exoplatform.services.portletcontainer.pci.model.Supports;
import org.exoplatform.services.portletcontainer.pci.model.UserAttribute;
import org.exoplatform.services.portletcontainer.pci.model.UserDataConstraint;

public class XMLParser {
    public static PortletApp readPortletApp(ExoXPPParser xpp) throws Exception {
        PortletApp pa = new PortletApp();
        pa.setVersion(xpp.getNodeAttributeValue("version"));
        while (xpp.node("portlet")) {
            pa.addPortlet(XMLParser.readPortlet(xpp));
        }
        while (xpp.node("custom-portlet-mode")) {
            pa.addCustomPortletMode(XMLParser.readCustomPortletMode(xpp));
        }
        while (xpp.node("custom-window-state")) {
            pa.addCustomWindowState(XMLParser.readCustomWindowState(xpp));
        }
        while (xpp.node("user-attribute")) {
            pa.addUserAttribute(XMLParser.readUserAttribute(xpp));
        }
        while (xpp.node("security-constraint")) {
            pa.addSecurityConstraint(XMLParser.readSecurityConstraint(xpp));
        }
        return pa;
    }

    public static Portlet readPortlet(ExoXPPParser xpp) throws Exception {
        Portlet p = new Portlet();
        while (xpp.node("description")) {
            p.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("portlet-name");
        p.setPortletName(xpp.getContent());
        while (xpp.node("display-name")) {
            p.addDisplayName(XMLParser.readDisplayName(xpp));
        }
        xpp.mandatoryNode("portlet-class");
        p.setPortletClass(xpp.getContent());
        while (xpp.node("init-param")) {
            p.addInitParam(XMLParser.readInitParam(xpp));
        }
        if (xpp.node("expiration-cache")) {
            p.setExpirationCache(xpp.getContent());
        }
        while (xpp.node("supports")) {
            p.addSupports(XMLParser.readSupports(xpp));
        }
        while (xpp.node("supported-locale")) {
            p.addSupportedLocale(xpp.getContent());
        }
        if (xpp.node("resource-bundle")) {
            p.setResourceBundle(xpp.getContent());
        }
        if (xpp.node("portlet-info")) {
            p.setPortletInfo(XMLParser.readPortletInfo(xpp));
        }
        if (xpp.node("portlet-preferences")) {
            p.setPortletPreferences(XMLParser.readPortletPreferences(xpp));
        }
        while (xpp.node("security-role-ref")) {
            p.addSecurityRoleRef(XMLParser.readSecurityRoleRef(xpp));
        }
        while (xpp.node("filter")) {
            p.addFilter(XMLParser.readFilter(xpp));
        }
        if (xpp.node("global-cache")) {
            p.setGlobalCache(xpp.getContent());
        }
        return p;
    }

    public static CustomPortletMode readCustomPortletMode(ExoXPPParser xpp) throws Exception {
        CustomPortletMode mode = new CustomPortletMode();
        while (xpp.node("description")) {
            mode.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("portlet-mode");
        mode.setPortletMode(xpp.getContent());
        return mode;
    }

    public static CustomWindowState readCustomWindowState(ExoXPPParser xpp) throws Exception {
        CustomWindowState state = new CustomWindowState();
        while (xpp.node("description")) {
            state.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("window-state");
        state.setWindowState(xpp.getContent());
        return state;
    }

    public static UserAttribute readUserAttribute(ExoXPPParser xpp) throws Exception {
        UserAttribute att = new UserAttribute();
        while (xpp.node("description")) {
            att.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("name");
        att.setName(xpp.getContent());
        return att;
    }

    public static SecurityConstraint readSecurityConstraint(ExoXPPParser xpp) throws Exception {
        SecurityConstraint sc = new SecurityConstraint();
        if (xpp.node("displayName")) {
            sc.setDisplayName(xpp.getContent());
        }
        xpp.mandatoryNode("portlet-collection");
        sc.setPortletCollection(XMLParser.readPortletCollection(xpp));
        xpp.mandatoryNode("user-data-constraint");
        sc.setUserDataConstraint(XMLParser.readUserDataConstraint(xpp));
        return sc;
    }

    public static Description readDescription(ExoXPPParser xpp) throws Exception {
        Description desc = new Description();
        desc.setLang(xpp.getNodeAttributeValue("xml:lang"));
        desc.setDescription(xpp.getContent());
        return desc;
    }

    public static DisplayName readDisplayName(ExoXPPParser xpp) throws Exception {
        DisplayName name = new DisplayName();
        name.setLang(xpp.getNodeAttributeValue("xml:lang"));
        name.setDisplayName(xpp.getContent());
        return name;
    }

    public static InitParam readInitParam(ExoXPPParser xpp) throws Exception {
        InitParam param = new InitParam();
        while (xpp.node("description")) {
            param.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("name");
        param.setName(xpp.getContent());
        xpp.mandatoryNode("value");
        param.setValue(xpp.getContent());
        return param;
    }

    public static Supports readSupports(ExoXPPParser xpp) throws Exception {
        Supports supports = new Supports();
        xpp.mandatoryNode("mime-type");
        supports.setMimeType(xpp.getContent());
        while (xpp.node("portlet-mode")) {
            supports.addPortletMode(xpp.getContent());
        }
        Iterator i = supports.getPortletMode().iterator();
        boolean viewListed = false;
        while (i.hasNext()) {
            if (!((String)i.next()).equalsIgnoreCase(PortletMode.VIEW.toString())) continue;
            viewListed = true;
            break;
        }
        if (!viewListed) {
            supports.addPortletMode(PortletMode.VIEW.toString());
        }
        return supports;
    }

    public static PortletInfo readPortletInfo(ExoXPPParser xpp) throws Exception {
        PortletInfo info = new PortletInfo();
        xpp.mandatoryNode("title");
        info.setTitle(xpp.getContent());
        if (xpp.node("short-title")) {
            info.setShortTitle(xpp.getContent());
        }
        if (xpp.node("keywords")) {
            info.setKeywords(xpp.getContent());
        }
        return info;
    }

    public static ExoPortletPreferences readPortletPreferences(ExoXPPParser xpp) throws Exception {
        ExoPortletPreferences prefs = new ExoPortletPreferences();
        while (xpp.node("preference")) {
            prefs.addPreference(XMLParser.readPreference(xpp));
        }
        if (xpp.node("preferences-validator")) {
            prefs.setPreferencesValidator(xpp.getContent());
        }
        return prefs;
    }

    public static Preference readPreference(ExoXPPParser xpp) throws Exception {
        Preference pref = new Preference();
        xpp.mandatoryNode("name");
        pref.setName(xpp.getContent());
        while (xpp.node("value")) {
            pref.addValue(xpp.getContent());
        }
        if (xpp.node("read-only")) {
            pref.setReadOnly(xpp.getContent());
        }
        return pref;
    }

    public static SecurityRoleRef readSecurityRoleRef(ExoXPPParser xpp) throws Exception {
        SecurityRoleRef ref = new SecurityRoleRef();
        xpp.mandatoryNode("role-name");
        ref.setRoleName(xpp.getContent());
        if (xpp.node("role-link")) {
            ref.setRoleLink(xpp.getContent());
        }
        return ref;
    }

    public static Filter readFilter(ExoXPPParser xpp) throws Exception {
        Filter filter = new Filter();
        xpp.mandatoryNode("filter-name");
        filter.setFilterName(xpp.getContent());
        xpp.mandatoryNode("filter-class");
        filter.setFilterClass(xpp.getContent());
        while (xpp.node("init-param")) {
            filter.addInitParam(XMLParser.readInitParam(xpp));
        }
        return filter;
    }

    public static PortletCollection readPortletCollection(ExoXPPParser xpp) throws Exception {
        PortletCollection collection = new PortletCollection();
        while (xpp.node("portlet-name")) {
            collection.addPortletName(xpp.getContent());
        }
        return collection;
    }

    public static UserDataConstraint readUserDataConstraint(ExoXPPParser xpp) throws Exception {
        UserDataConstraint u = new UserDataConstraint();
        while (xpp.node("description")) {
            u.addDescription(XMLParser.readDescription(xpp));
        }
        xpp.mandatoryNode("transport-guarantee");
        u.setTransportGuarantie(xpp.getContent());
        return u;
    }

    public static PortletApp parse(InputStream is) throws Exception {
        ExoXPPParser xpp = ExoXPPParser.getInstance();
        xpp.setInput(is, "UTF8");
        xpp.mandatoryNode("portlet-app");
        return XMLParser.readPortletApp(xpp);
    }
}

