/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class BootLoginModule
implements LoginModule {
    private static final String moduleClass = "org.exoplatform.services.security.jaas.StandaloneLoginModule";
    private LoginModule delegatee = null;
    private Subject subject_;
    private CallbackHandler callbackHandler_;
    private Map sharedState_;
    private Map options_;

    private boolean initDelegatee() {
        if (this.delegatee == null && System.getProperty("exo.standalone-container") != null) {
            try {
                Class<?> c = null;
                try {
                    c = Class.forName(moduleClass);
                }
                catch (Exception e) {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    try {
                        c = cl.loadClass(moduleClass);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                if (c != null) {
                    this.delegatee = (LoginModule)c.newInstance();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.delegatee != null) {
                this.delegatee.initialize(this.subject_, this.callbackHandler_, this.sharedState_, this.options_);
            }
        }
        return this.delegatee != null;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject_ = subject;
        this.callbackHandler_ = callbackHandler;
        this.sharedState_ = sharedState;
        this.options_ = options;
        this.initDelegatee();
    }

    public boolean login() throws LoginException {
        if (this.initDelegatee()) {
            return this.delegatee.login();
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.initDelegatee()) {
            return this.delegatee.commit();
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (this.initDelegatee()) {
            return this.delegatee.abort();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.initDelegatee()) {
            return this.delegatee.logout();
        }
        return true;
    }
}

