/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.List;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.servlet.ServletContext;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.groovy.ExoGroovyComponentAdapter;
import org.exoplatform.container.groovy.GroovyManager;
import org.exoplatform.container.groovy.GroovyManagerListener;
import org.exoplatform.container.groovy.GroovyObject;
import org.exoplatform.container.jmx.MX4JComponentAdapterFactory;
import org.exoplatform.container.monitor.PortalMonitor;
import org.exoplatform.container.util.ContainerUtil;
import org.exoplatform.container.xml.PortalContainerInfo;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;

public class PortalContainer
extends ExoContainer {
    public static final String SESSION_CONTAINER_CONFIG = "session.container.config";
    private static ThreadLocal currentContainer_ = new ThreadLocal();
    private MBeanServer mbeanServer;
    private ServletContext portalServletContext_;
    private GroovyManager gmanager_;
    private PortalMonitor monitor_;
    private boolean started_ = false;
    static /* synthetic */ Class class$org$picocontainer$Startable;

    public PortalContainer(PicoContainer parent, ServletContext portalContext) {
        super(new MX4JComponentAdapterFactory(), parent);
        this.portalServletContext_ = portalContext;
        this.mbeanServer = MBeanServerFactory.createMBeanServer("portalmx");
        this.registerComponentInstance(ServletContext.class, portalContext);
        this.monitor_ = new PortalMonitor();
        this.registerComponentInstance(PortalMonitor.class, this.monitor_);
        PortalContainerInfo info = new PortalContainerInfo(portalContext.getServletContextName());
        this.registerComponentInstance(PortalContainerInfo.class, info);
    }

    public ServletContext getPortalServletContext() {
        return this.portalServletContext_;
    }

    public PortalMonitor getMonitor() {
        return this.monitor_;
    }

    public SessionContainer createSessionContainer(String id, String owner) {
        SessionContainer scontainer = (SessionContainer)((Object)this.getComponentInstance(id));
        if (scontainer != null) {
            this.unregisterComponent(id);
            scontainer.stop();
        }
        scontainer = new SessionContainer(this, id, owner);
        ConfigurationManager cService = (ConfigurationManager)this.getComponentInstance(SESSION_CONTAINER_CONFIG);
        ContainerUtil.populate(scontainer, cService);
        scontainer.setPortalName(this.portalServletContext_.getServletContextName());
        this.registerComponentInstance(id, (Object)scontainer);
        scontainer.start();
        SessionContainer.setInstance(scontainer);
        return scontainer;
    }

    public void removeSessionContainer(String id) {
        this.unregisterComponent(id);
    }

    public List getLiveSessions() {
        return this.getComponentInstancesOfType(SessionContainer.class);
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public GroovyManager getGroovyManager() {
        return this.gmanager_;
    }

    public void setGroovyManager(GroovyManager gmanager) {
        this.gmanager_ = gmanager;
        this.gmanager_.removeAllListener();
        this.gmanager_.addListener(new PortalGroovyObjectListener());
    }

    private ExoContainer getThisContainer() {
        return this;
    }

    public static PortalContainer getInstance() {
        PortalContainer container = (PortalContainer)((Object)currentContainer_.get());
        if (container == null) {
            container = RootContainer.getInstance().getPortalContainer("default");
            currentContainer_.set(container);
        }
        return container;
    }

    public boolean isStarted() {
        return this.started_;
    }

    public void start() {
        super.start();
        this.started_ = true;
    }

    public void stop() {
        this.gmanager_.setDispose(true);
        super.stop();
        this.started_ = false;
    }

    public synchronized ComponentAdapter getComponentAdapterOfType(Class componentType) {
        return super.getComponentAdapterOfType(componentType);
    }

    public synchronized List getComponentAdaptersOfType(Class componentType) {
        return super.getComponentAdaptersOfType(componentType);
    }

    public synchronized ComponentAdapter unregisterComponent(Object componentKey) {
        return super.unregisterComponent(componentKey);
    }

    public synchronized ComponentAdapter registerComponent(ComponentAdapter componentAdapter) throws DuplicateComponentKeyRegistrationException {
        return super.registerComponent(componentAdapter);
    }

    public synchronized List getComponentInstancesOfType(Class componentType) throws PicoException {
        return super.getComponentInstancesOfType(componentType);
    }

    public static void setInstance(PortalContainer instance) {
        currentContainer_.set(instance);
    }

    public static Object getComponent(Class key) {
        PortalContainer pcontainer = (PortalContainer)((Object)currentContainer_.get());
        return pcontainer.getComponentInstanceOfType(key);
    }

    public class PortalGroovyObjectListener
    extends GroovyManagerListener {
        public void load(GroovyObject gobject) throws Exception {
            PortalContainer.this.registerComponent((ComponentAdapter)new ExoGroovyComponentAdapter(gobject));
        }

        public void reload(GroovyObject gobject) throws Exception {
            PortalContainer.this.registerComponent((ComponentAdapter)new ExoGroovyComponentAdapter(gobject));
            Class type = gobject.getType();
            if ((class$org$picocontainer$Startable == null ? (class$org$picocontainer$Startable = PortalContainer.class$("org.picocontainer.Startable")) : class$org$picocontainer$Startable).isAssignableFrom(type)) {
                ExoGroovyComponentAdapter adapter = (ExoGroovyComponentAdapter)PortalContainer.this.getComponentAdapter(gobject.getType());
                adapter.getComponentInstance((PicoContainer)PortalContainer.this.getThisContainer());
            }
        }

        public void unload(GroovyObject gobject) throws Exception {
            PortalContainer.this.unregisterComponent(gobject.getType());
            gobject.setObject(null);
        }
    }
}

