/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.client.http;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.wurfl.wurflapi.CapabilityMatrix;
import net.sourceforge.wurfl.wurflapi.ObjectsManager;
import net.sourceforge.wurfl.wurflapi.UAManager;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.exoplatform.container.client.http.HttpClientType;

public class ClientTypeMap {
    public static final String XHTML_MIME_TYPE = "text/xhtml";
    public static final String XHTMLMP_MIME_TYPE = "application/vnd.wap.xhtml+xml";
    private ArrayList clientList_ = new ArrayList();
    private static ClientTypeMap singleton_;

    private void loadClientsInfos() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL url = cl.getResource("conf/portal/clients-type.xml");
            SAXReader reader = new SAXReader();
            Document document = reader.read(url.openStream());
            List list = document.selectNodes("//clients-type/client-type");
            for (int i = 0; i < list.size(); ++i) {
                Node node = (Node)list.get(i);
                String name = node.selectSingleNode("name").getText();
                String userAgentPattern = node.selectSingleNode("userAgentPattern").getText();
                String preferredMimeType = node.selectSingleNode("preferredMimeType").getText();
                String renderer = node.selectSingleNode("type").getText();
                HttpClientType clientInfo = renderer.length() > 0 ? new HttpClientType(name, userAgentPattern, preferredMimeType, renderer) : new HttpClientType(name, userAgentPattern, preferredMimeType);
                this.addClientInfo(clientInfo);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ClientTypeMap() {
        this.loadClientsInfos();
    }

    protected void addClientInfo(HttpClientType clientInfo) {
        this.clientList_.add(clientInfo);
    }

    public HttpClientType findClient(String userAgent) {
        if (userAgent == null) {
            return (HttpClientType)this.clientList_.get(0);
        }
        if (userAgent.equals("")) {
            return (HttpClientType)this.clientList_.get(0);
        }
        for (int i = 0; i < this.clientList_.size(); ++i) {
            HttpClientType client = (HttpClientType)this.clientList_.get(i);
            String userAgentPattern = client.getUserAgentPattern();
            if (userAgentPattern == null) continue;
            try {
                if (!userAgent.matches(userAgentPattern)) continue;
                return client;
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace();
                return (HttpClientType)this.clientList_.get(0);
            }
        }
        UAManager uam = ObjectsManager.getUAManagerInstance();
        String deviceID = uam.getDeviceIDFromUALoose(userAgent);
        if (!deviceID.equals("")) {
            CapabilityMatrix cm = ObjectsManager.getCapabilityMatrixInstance();
            String name = cm.getCapabilityForDevice(deviceID, "model_name");
            if (cm.getCapabilityForDevice(deviceID, "preferred_markup").equals("html_wi_oma_xhtmlmp_1_0")) {
                return new HttpClientType(name, deviceID, XHTMLMP_MIME_TYPE, "mobile-browser");
            }
        }
        return (HttpClientType)this.clientList_.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientTypeMap getInstance() {
        if (singleton_ == null) {
            Class clazz = ClientTypeMap.class;
            synchronized (clazz) {
                singleton_ = new ClientTypeMap();
            }
        }
        return singleton_;
    }
}

