/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.groovy.GroovyManagerListener;
import org.exoplatform.container.groovy.GroovyObject;

public class GroovyManager {
    private URL classpath_;
    private Map cacheObject_;
    private GroovyClassLoader gcl_;
    private List listeners_;
    private boolean dispose_;

    public GroovyManager(URL classpath) throws Exception {
        this.classpath_ = classpath;
        this.listeners_ = new ArrayList(5);
        this.listeners_.add(new GroovyManagerListener());
        this.cacheObject_ = new HashMap();
        this.gcl_ = this.createGroovyClassLoader();
        this.dispose_ = false;
    }

    public boolean isDispose() {
        return this.dispose_;
    }

    public void setDispose(boolean b) {
        this.dispose_ = b;
    }

    public String getGroovyClassPath() {
        return this.classpath_.toString();
    }

    public synchronized void addListener(GroovyManagerListener listener) {
        this.listeners_.add(listener);
    }

    public synchronized void removeListener(GroovyManagerListener listener) {
        this.listeners_.remove(listener);
    }

    public synchronized void removeAllListener() {
        this.listeners_.clear();
    }

    public Object getObject(String resource) throws Exception {
        GroovyObject gobject = this.getGroovyObject(resource);
        if (gobject.getType() == null) {
            gobject.setType(this.gcl_);
            GroovyManagerListener.reload(this.listeners_, gobject);
        }
        return gobject.getObject();
    }

    public GroovyClassLoader getGroovyClassLoader() {
        return this.gcl_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroovyObject getGroovyObject(String resource) throws Exception {
        GroovyObject gobject = (GroovyObject)this.cacheObject_.get(resource);
        if (gobject == null) {
            Map map = this.cacheObject_;
            synchronized (map) {
                gobject = new GroovyObject(resource);
                gobject.setType(this.gcl_);
                GroovyManagerListener.load(this.listeners_, gobject);
                this.cacheObject_.put(resource, gobject);
            }
        }
        return gobject;
    }

    public String getGroovyObjectAsText(String resource) throws Exception {
        return IOUtil.getStreamContentAsString((InputStream)this.gcl_.getResourceAsStream(resource));
    }

    public void saveGroovyObject(String resource, String text) throws Exception {
        String url = this.gcl_.getResource(resource).toString();
        if (!url.startsWith("file:")) {
            throw new Exception("The  resources is in a jar file........");
        }
        String filePath = url.substring("file:".length() + 1, url.length());
        FileOutputStream os = new FileOutputStream(filePath);
        os.write(text.getBytes());
        os.close();
    }

    private GroovyClassLoader createGroovyClassLoader() throws Exception {
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        if (this.classpath_ != null) {
            URL[] url = new URL[]{this.classpath_};
            parentLoader = new URLClassLoader(url, Thread.currentThread().getContextClassLoader());
            String cpath = System.getProperty("java.class.path");
            String newpath = this.classpath_.toString();
            if (cpath.indexOf(newpath = newpath.substring("file:".length(), newpath.length())) < 0) {
                cpath = cpath + File.pathSeparator + newpath;
                System.setProperty("java.class.path", cpath);
            }
        }
        return new GroovyClassLoader(parentLoader);
    }

    public void checkModifiedObjects() throws Exception {
        Iterator i = this.cacheObject_.values().iterator();
        while (i.hasNext()) {
            GroovyObject gobject = (GroovyObject)i.next();
            if (!gobject.isReloadable() || !this.isObjectModified(gobject)) continue;
            this.reloadGroovyObjects();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadGroovyObjects() throws Exception {
        Map map = this.cacheObject_;
        synchronized (map) {
            Iterator i = this.cacheObject_.values().iterator();
            this.gcl_ = this.createGroovyClassLoader();
            while (i.hasNext()) {
                GroovyObject gobject = (GroovyObject)i.next();
                GroovyManagerListener.unload(this.listeners_, gobject);
                gobject.setObject(null);
            }
        }
    }

    private boolean isObjectModified(GroovyObject gobject) throws Exception {
        URL resourceURL = this.gcl_.getResource(gobject.getGroovyResource());
        if (resourceURL == null) {
            return false;
        }
        String url = resourceURL.toString();
        String filePath = url.substring("file:".length(), url.length());
        File file = new File(filePath);
        long lastModifiedTime = file.lastModified();
        return lastModifiedTime > gobject.getLoadTime();
    }
}

