/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.groovy;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.groovy.GroovyManager;
import org.exoplatform.container.xml.ServiceConfiguration;
import org.exoplatform.container.xml.ValueParam;
import org.picocontainer.Startable;

public class GroovyManagerContainer
implements Startable {
    private Map managers_;
    private Thread scanner_;

    public GroovyManagerContainer(ConfigurationManager cService) throws Exception {
        ServiceConfiguration sconf = cService.getServiceConfiguration(this.getClass());
        ValueParam param = sconf.getValueParam("check.modified.period");
        long period = Long.parseLong(param.getValue());
        if (period > 0L) {
            this.scanner_ = new ScannerThread(period);
            this.scanner_.setDaemon(true);
            this.scanner_.start();
        }
        this.managers_ = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroovyManager getGroovyManager(URL classpath) throws Exception {
        String id = classpath.toString();
        GroovyManager manager = (GroovyManager)this.managers_.get(id);
        if (manager == null) {
            Map map = this.managers_;
            synchronized (map) {
                manager = new GroovyManager(classpath);
                this.managers_.put(id, manager);
            }
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroovyManager removeGroovyManager(URL classpath) throws Exception {
        Map map = this.managers_;
        synchronized (map) {
            GroovyManager manager = (GroovyManager)this.managers_.remove(classpath.toString());
            return manager;
        }
    }

    public void start() {
    }

    public void stop() {
        if (this.scanner_ != null) {
            this.scanner_.interrupt();
        }
    }

    public class ScannerThread
    extends Thread {
        private long period_;

        public ScannerThread(long period) {
            this.setPriority(1);
            this.period_ = period;
        }

        public void run() {
            long checkPeriod = 20000L;
            while (true) {
                try {
                    block4: while (true) {
                        ScannerThread.sleep(checkPeriod);
                        if (GroovyManagerContainer.this.managers_.size() == 0) {
                            return;
                        }
                        checkPeriod = this.period_;
                        Iterator i = GroovyManagerContainer.this.managers_.values().iterator();
                        while (true) {
                            if (!i.hasNext()) continue block4;
                            GroovyManager gmanager = (GroovyManager)i.next();
                            if (gmanager.isDispose()) {
                                i.remove();
                                continue;
                            }
                            gmanager.checkModifiedObjects();
                        }
                        break;
                    }
                }
                catch (InterruptedException ex) {
                    return;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

