/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.SessionContainer;
import org.exoplatform.container.monitor.ActionData;
import org.exoplatform.container.monitor.PortalMonitorListener;
import org.exoplatform.container.monitor.PortalMonitorListenerStack;
import org.exoplatform.container.monitor.RequestMonitorData;

public class PortalMonitor {
    static int NUMBER_OF_REQUEST_MONITOR = 10;
    static long TIME_RANGE = 200L;
    private List requestMonitors_ = new ArrayList();
    private PortalMonitorListenerStack listeners_;

    public PortalMonitor() {
        long min = 0L;
        long max = TIME_RANGE - 1L;
        for (int i = 0; i < NUMBER_OF_REQUEST_MONITOR; ++i) {
            this.requestMonitors_.add(new RequestMonitorData(min, max));
            min += TIME_RANGE;
            max += TIME_RANGE;
        }
        this.listeners_ = new PortalMonitorListenerStack(3);
    }

    public void addListener(PortalMonitorListener listener) {
        this.listeners_.add(listener);
    }

    public final void log(ActionData data) {
        long executionTime = data.getHandleTime();
        int index = (int)(executionTime / TIME_RANGE);
        if (index >= NUMBER_OF_REQUEST_MONITOR) {
            index = NUMBER_OF_REQUEST_MONITOR - 1;
        }
        RequestMonitorData monitor = (RequestMonitorData)this.requestMonitors_.get(index);
        monitor.logRequest(executionTime);
    }

    public void error(String errorMessage, Throwable t) {
        this.listeners_.onError(this, errorMessage, t);
        SessionContainer scontainer = SessionContainer.getInstance();
        if (scontainer != null) {
            scontainer.getMonitor().error(errorMessage, t);
        }
    }

    public final List getRequestMonitorData() {
        return this.requestMonitors_;
    }

    public final int getRequestCounter() {
        int counter = 0;
        for (int i = 0; i < NUMBER_OF_REQUEST_MONITOR; ++i) {
            RequestMonitorData monitor = (RequestMonitorData)this.requestMonitors_.get(i);
            counter += monitor.getRequestCounter();
        }
        return counter;
    }

    public final long minExecutionTime() {
        long minExecutionTime = 0L;
        for (int i = 0; i < NUMBER_OF_REQUEST_MONITOR; ++i) {
            RequestMonitorData monitor = (RequestMonitorData)this.requestMonitors_.get(i);
            if (i == 0) {
                minExecutionTime = monitor.minExecutionTime();
                continue;
            }
            if (monitor.minExecutionTime() >= minExecutionTime) continue;
            minExecutionTime = monitor.minExecutionTime();
        }
        return minExecutionTime;
    }

    public final long maxExecutionTime() {
        long maxExecutionTime = 0L;
        for (int i = 0; i < NUMBER_OF_REQUEST_MONITOR; ++i) {
            RequestMonitorData monitor = (RequestMonitorData)this.requestMonitors_.get(i);
            if (i == 0) {
                maxExecutionTime = monitor.maxExecutionTime();
                continue;
            }
            if (monitor.maxExecutionTime() <= maxExecutionTime) continue;
            maxExecutionTime = monitor.maxExecutionTime();
        }
        return maxExecutionTime;
    }

    public final long averageExecutionTime() {
        long sumExecutionTime = 0L;
        int requestCounter = 0;
        for (int i = 0; i < NUMBER_OF_REQUEST_MONITOR; ++i) {
            RequestMonitorData monitor = (RequestMonitorData)this.requestMonitors_.get(i);
            sumExecutionTime += monitor.sumExecutionTime();
            requestCounter += monitor.getRequestCounter();
        }
        if (requestCounter == 0) {
            return 0L;
        }
        return sumExecutionTime / (long)requestCounter;
    }
}

