/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm.v14;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.Constants;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.monitor.jvm.JVMRuntimeInfo;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ServiceConfiguration;
import org.picocontainer.Startable;

public class JVMRuntimeInfoImpl
implements JVMRuntimeInfo,
Startable {
    public JVMRuntimeInfoImpl(ConfigurationManager manager) throws Exception {
        ServiceConfiguration sconf = manager.getServiceConfiguration(JVMRuntimeInfo.class);
        PropertiesParam param = sconf.getPropertiesParam("add.system.properties");
        if (param != null) {
            ExoProperties props = param.getProperties();
            Iterator i = props.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                System.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public String getName() {
        return "N/A";
    }

    public String getSpecName() {
        return "N/A";
    }

    public String getSpecVendor() {
        return "N/A";
    }

    public String getSpecVersion() {
        return "N/A";
    }

    public String getManagementSpecVersion() {
        return "N/A";
    }

    public String getVmName() {
        return "N/A";
    }

    public String getVmVendor() {
        return "N/A";
    }

    public String getVmVersion() {
        return "N/A";
    }

    public List getInputArguments() {
        return Constants.EMPTY_LIST;
    }

    public Map getSystemProperties() {
        return Constants.EMPTY_MAP;
    }

    public boolean getBootClassPathSupported() {
        return false;
    }

    public String getBootClassPath() {
        return "N/A";
    }

    public String getClassPath() {
        return "N/A";
    }

    public String getLibraryPath() {
        return "N/A";
    }

    public long getStartTime() {
        return -1L;
    }

    public long getUptime() {
        return -1L;
    }

    public boolean isManagementSupported() {
        return false;
    }

    public String getSystemPropertiesAsText() {
        StringBuffer b = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> i = System.getProperties().entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            b.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        return b.toString();
    }

    public void start() {
    }

    public void stop() {
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Name: ").append(this.getName()).append("\n");
        b.append("Specification Name: ").append(this.getSpecName()).append("\n");
        b.append("Specification Vendor: ").append(this.getSpecVendor()).append("\n");
        b.append("Specification Version: ").append(this.getSpecVersion()).append("\n");
        b.append("Management Spec Version: ").append(this.getManagementSpecVersion()).append("\n\n");
        b.append("Virtual Machine Name: ").append(this.getVmName()).append("\n");
        b.append("Virtual Machine Vendor: ").append(this.getVmVendor()).append("\n");
        b.append("Virtual Machine Version: ").append(this.getVmVersion()).append("\n\n");
        b.append("Input Arguments: ").append(this.getInputArguments()).append("\n");
        b.append("System Properties: ").append(this.getSystemProperties()).append("\n\n");
        b.append("Boot Class Path Support: ").append(this.getBootClassPathSupported()).append("\n");
        b.append("Boot Class Path: ").append(this.getBootClassPath()).append("\n");
        b.append("Class Path: ").append(this.getClassPath()).append("\n");
        b.append("Library Path: ").append(this.getLibraryPath()).append("\n\n");
        b.append("Start Time: ").append(new Date(this.getStartTime())).append("\n");
        b.append("Up Time: ").append(this.getUptime() / 60000L).append("min\n");
        return b.toString();
    }
}

