/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.groovy.GroovyManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ServiceConfiguration;

public class ContainerUtil {
    public static Collection getConfigurationURL(String configuration) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ArrayList<URL> c = Collections.list(cl.getResources(configuration));
        return c;
    }

    public static void populate(ExoContainer container, ConfigurationManager conf) {
        ContainerUtil.populateOld(container, conf);
        ContainerUtil.populateNew(container, conf);
    }

    public static void populateOld(ExoContainer container, ConfigurationManager conf) {
        Collection serviceConfigurations = conf.getServiceConfigurations();
        if (serviceConfigurations == null) {
            return;
        }
        Iterator i = serviceConfigurations.iterator();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while (i.hasNext()) {
            ServiceConfiguration sconf = (ServiceConfiguration)i.next();
            String type = sconf.getServiceType();
            String key = sconf.getServiceKey();
            try {
                Class<?> classType = loader.loadClass(type);
                if (key == null) {
                    container.registerComponentImplementation(classType);
                    continue;
                }
                try {
                    Class<?> keyType = loader.loadClass(key);
                    container.registerComponentImplementation(keyType, classType);
                }
                catch (Exception ex) {
                    container.registerComponentImplementation(key, classType);
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void populateNew(ExoContainer container, ConfigurationManager conf) {
        Collection components = conf.getComponents();
        if (components == null) {
            return;
        }
        if (components == null) {
            return;
        }
        Iterator i = components.iterator();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while (i.hasNext()) {
            Component component = (Component)i.next();
            String type = component.getType();
            String key = component.getKey();
            try {
                Class<?> classType = loader.loadClass(type);
                if (key == null) {
                    container.registerComponentImplementation(classType);
                    continue;
                }
                try {
                    Class<?> keyType = loader.loadClass(key);
                    container.registerComponentImplementation(keyType, classType);
                }
                catch (Exception ex) {
                    container.registerComponentImplementation(key, classType);
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void populateGroovy(ExoContainer container, ConfigurationManager conf) throws Exception {
        Iterator i = conf.getGroovyServiceConfigurations().iterator();
        GroovyManager gmanager = container.getGroovyManager();
        while (i.hasNext()) {
            ServiceConfiguration sconf = (ServiceConfiguration)i.next();
            String type = sconf.getServiceType();
            gmanager.getObject(type);
        }
    }
}

