/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor.sax;

import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedRegionAdpater;
import fr.opensagres.xdocreport.document.preprocessor.sax.IBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.ISavable;
import fr.opensagres.xdocreport.document.preprocessor.sax.StringBufferedRegion;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class BufferedRegion
extends BufferedRegionAdpater {
    protected final List<ISavable> regions = new ArrayList<ISavable>();
    private IBufferedRegion currentRegion;

    public BufferedRegion(BufferedElement ownerElement, IBufferedRegion parent) {
        super(ownerElement, parent);
    }

    @Override
    public void save(Writer writer) throws IOException {
        for (ISavable region : this.regions) {
            region.save(writer);
        }
    }

    @Override
    public void addRegion(ISavable region) {
        this.currentRegion = region instanceof IBufferedRegion ? (IBufferedRegion)region : this.currentRegion;
        this.regions.add(region);
    }

    @Override
    public void append(String content) {
        this.getStringBufferedRegion().append(content);
    }

    @Override
    public void append(char c) {
        this.getStringBufferedRegion().append(c);
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public void append(char[] ch, int start, int length) {
        this.getStringBufferedRegion().append(ch, start, length);
    }

    private StringBufferedRegion getStringBufferedRegion() {
        if (this.currentRegion == null || !this.currentRegion.isString()) {
            this.currentRegion = new StringBufferedRegion(this.getOwnerElement(), this);
        }
        return (StringBufferedRegion)this.currentRegion;
    }

    public void reset() {
        this.regions.clear();
        this.currentRegion = null;
    }
}

