/*
 * Decompiled with CFR 0.152.
 */
package gr.abiss.mvn.plugins.jstools;

import gr.abiss.mvn.plugins.jstools.AbstractBaseJstoolsReport;
import gr.abiss.mvn.plugins.jstools.utils.FileSystemDirectoryUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.mozilla.javascript.tools.shell.Main;

public class JsDocMojo
extends AbstractBaseJstoolsReport {
    private String template;
    private String jsdocHome;
    private boolean includePrivate;
    private boolean includeUndocumented;
    private boolean includeUndocumentedUnderscored;
    private boolean jArgument;

    public void doGenerateReport(Locale defaultLocale) throws MavenReportException {
        String systemJsdocDir = System.getProperty("jsdoc.dir");
        System.setProperty("jsdoc.dir", this.jsdocHome);
        if (systemJsdocDir != null) {
            this.getLog().debug((CharSequence)("Temporarily switched the system's 'sdoc.dir' property to: " + System.getProperty("jsdoc.dir")));
        }
        ArrayList<String> args = new ArrayList<String>();
        ByteArrayOutputStream baos = null;
        PrintStream ps = null;
        if (!this.getLog().isDebugEnabled()) {
            baos = new ByteArrayOutputStream();
            ps = new PrintStream(baos);
            Main.setOut((PrintStream)ps);
        }
        String runJsPath = this.jsdocHome + "/app/run.js";
        args.add(runJsPath);
        if (this.includeUndocumented) {
            args.add("-a");
        }
        if (this.includeUndocumentedUnderscored) {
            args.add("-A");
        }
        if (this.includePrivate) {
            args.add("-p");
        }
        args.add("-d=" + this.getOutputDirectory());
        String targetTemplate = this.template.indexOf(File.separator) != -1 ? this.template : this.jsdocHome + "/templates/" + this.template;
        args.add("-t=" + targetTemplate);
        Set<File> jsfiles = this.getJavaScriptFiles();
        Iterator<File> iter = jsfiles.iterator();
        while (iter.hasNext()) {
            args.add(iter.next().getAbsolutePath());
        }
        if (this.jArgument) {
            args.add("-j=" + runJsPath);
        }
        this.getLog().debug((CharSequence)("Executing: '" + ((Object)args).toString().replaceAll(",", "") + "'"));
        Main.exec((String[])args.toArray(new String[0]));
        if (systemJsdocDir != null) {
            System.setProperty("jsdoc.dir", systemJsdocDir);
            this.getLog().debug((CharSequence)("Switched the system's 'sdoc.dir' property back to original value: " + System.getProperty("jsdoc.dir")));
        }
        try {
            File in = new File(this.getOutputDirectory() + "/" + "index.htm");
            if (in.exists()) {
                File out = new File(this.getOutputDirectory() + "/" + "index.html");
                FileChannel sourceChannel = new FileInputStream(in).getChannel();
                FileChannel destinationChannel = new FileOutputStream(out).getChannel();
                sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
                sourceChannel.close();
                destinationChannel.close();
            }
        }
        catch (IOException e) {
            throw new MavenReportException("Could not copy file");
        }
    }

    protected void setUp(Locale defaultLocale) throws MavenReportException {
        if (this.jsdocHome == null || this.jsdocHome.trim().length() == 0) {
            String jsdocDistFilename = this.getBundle(defaultLocale).getString("jsdoc.dist.filename");
            this.jsdocHome = this.buildDir + "/jsdoc_run/" + jsdocDistFilename;
            String jsDocJar = this.baseDir + "/target/" + jsdocDistFilename + ".zip";
            try {
                InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream("/" + jsdocDistFilename + ".zip");
                FileOutputStream output = new FileOutputStream(jsDocJar);
                IOUtils.copy((InputStream)input, (OutputStream)output);
                input.close();
                ((OutputStream)output).close();
            }
            catch (FileNotFoundException fe) {
                throw new MavenReportException("Cannot find " + jsdocDistFilename + ".zip" + " in classpath", (Exception)fe);
            }
            catch (IOException ioe) {
                throw new MavenReportException("Error copying " + jsdocDistFilename + ".zip" + " to target dir", (Exception)ioe);
            }
            File jarFile = new File(jsDocJar);
            try {
                UnArchiver unArchiver = this.archiverManager.getUnArchiver(jarFile);
                unArchiver.setSourceFile(jarFile);
                File destDir = new File(this.jsdocHome).getParentFile();
                destDir.mkdirs();
                unArchiver.setDestDirectory(destDir);
                unArchiver.extract();
            }
            catch (NoSuchArchiverException ae) {
                throw new MavenReportException("Unknown archiver type", (Exception)((Object)ae));
            }
            catch (ArchiverException ae) {
                throw new MavenReportException("Error unpacking " + jarFile + ": " + ae.toString(), (Exception)((Object)ae));
            }
        }
    }

    public boolean isExternalReport() {
        return true;
    }

    public String getBundleKey() {
        return "jsdoc";
    }

    protected void tearDown(Locale defaultLocale) throws MavenReportException {
        try {
            File jsdocJar;
            File runDir = new File(this.buildDir + "/jsdoc_run/");
            if (runDir.exists()) {
                FileSystemDirectoryUtils.deleteDirectory(runDir);
            }
            if ((jsdocJar = new File(this.baseDir + "/target/" + this.getBundle(defaultLocale).getString("jsdoc.dist.filename") + ".zip")).exists()) {
                jsdocJar.delete();
            }
        }
        catch (Exception ioe) {
            throw new MavenReportException("Error clearing up", ioe);
        }
    }
}

