/*
 * Decompiled with CFR 0.152.
 */
package gr.abiss.mvn.plugins.jstools;

import gr.abiss.mvn.plugins.jstools.AbstractBaseJstoolsReport;
import gr.abiss.mvn.plugins.jstools.utils.FileSystemDirectoryUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JsLintMojo
extends AbstractBaseJstoolsReport {
    private String jslintInitJsFilePath;
    private String jslintJsFilePath;
    private boolean reportJslintErrorsOnly;
    boolean adsafe = true;
    boolean bitwise = true;
    boolean browser = true;
    boolean cap = true;
    boolean debug = true;
    boolean eqeqeq = true;
    boolean evil = true;
    boolean fragment = true;
    boolean laxbreak = true;
    boolean nomen = true;
    boolean passfail = true;
    boolean plusplus = true;
    boolean rhino = true;
    boolean undef = true;
    boolean white = true;
    boolean widget = true;

    public void doGenerateReport(Locale defaultLocale) throws MavenReportException {
        try {
            File outDir = new File(this.getOutputDirectory());
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            Set<File> jsFiles = this.getJavaScriptFiles();
            Sink sink = this.getSink();
            sink.head();
            sink.title();
            sink.text("JSLint Coverage Report");
            sink.title_();
            sink.head_();
            sink.body();
            sink.section1();
            sink.sectionTitle1();
            sink.text("Overview");
            sink.sectionTitle1_();
            sink.paragraph();
            sink.rawText("This report was build with <a href=\"http://www.jslint.com/\">JSLint</a>, the JavaScript Verifier. JSLint is a JavaScript program that looks for problems in other JavaScript programs.");
            sink.paragraph_();
            if (jsFiles.size() > 0) {
                String jsLintCode = this.getFileAsString(this.jslintJsFilePath) + this.getFileAsString(this.jslintInitJsFilePath);
                sink.paragraph();
                sink.text("Here is the list of files in this report:");
                sink.paragraph_();
                sink.list();
                for (File jsFile : jsFiles) {
                    sink.listItem();
                    sink.rawText("<a href=\"#_" + jsFile.getName().replaceAll(" ", "") + "\">" + jsFile.getName() + "</a>");
                    sink.listItem_();
                }
                sink.list_();
                sink.section1_();
                for (File jsFile : jsFiles) {
                    ByteArrayOutputStream buff = this.runJslintOnSource(jsLintCode, jsFile.getAbsolutePath());
                    sink.rawText("<a id=\"_" + jsFile.getName().replaceAll(" ", "") + "\"> </a>");
                    sink.sectionTitle1();
                    sink.text(jsFile.getName());
                    sink.sectionTitle1_();
                    sink.rawText("<div class=\"source\"><pre>" + (buff.size() > 0 ? buff.toString() : "No problems found") + "</pre></div>");
                }
            } else {
                sink.paragraph();
                sink.text("There are currently no files in this report.");
                sink.paragraph_();
            }
            sink.body_();
            sink.flush();
            sink.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MavenReportException("Error building JSLint report", e);
        }
    }

    private ByteArrayOutputStream runJslintOnSource(String jsLintCode, String sourceFilePath) {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buff);
        Context context = Context.enter();
        Scriptable scope = context.initStandardObjects(null);
        Scriptable varOut = Context.toObject((Object)out, (Scriptable)scope);
        scope.put("out", scope, (Object)varOut);
        Scriptable varSourceFilePath = Context.toObject((Object)sourceFilePath, (Scriptable)scope);
        scope.put("sourceFilePath", scope, (Object)varSourceFilePath);
        Scriptable varReportJslintErrorsOnly = Context.toObject((Object)this.reportJslintErrorsOnly, (Scriptable)scope);
        scope.put("reportJslintErrorsOnly", scope, (Object)varReportJslintErrorsOnly);
        context.evaluateString(scope, jsLintCode, "mvn-jstools jslint script", 1, null);
        return buff;
    }

    protected void setUp(Locale defaultLocale) throws MavenReportException {
        try {
            File destDir = new File(this.buildDir + "/jslint");
            destDir.mkdirs();
            this.copyScript("/jslint/fulljslint.js", this.buildDir + "/jslint/fulljslint.js");
            this.copyScript("/jslint/fulljslint_init.js", this.buildDir + "/jslint/fulljslint_init.js");
        }
        catch (FileNotFoundException fe) {
            throw new MavenReportException("Cannot find resource in classpath", (Exception)fe);
        }
        catch (IOException ioe) {
            throw new MavenReportException("Error copying resource to target dir", (Exception)ioe);
        }
    }

    protected void tearDown(Locale defaultLocale) throws MavenReportException {
        try {
            File runDir = new File(this.buildDir + "/jslint");
            if (runDir.exists()) {
                FileSystemDirectoryUtils.deleteDirectory(runDir);
            }
        }
        catch (Exception ioe) {
            throw new MavenReportException("Error clearing up", ioe);
        }
    }

    private void copyScript(String classpath, String filePath) throws FileNotFoundException, IOException {
        InputStream input = ((Object)((Object)this)).getClass().getResourceAsStream(classpath);
        FileOutputStream output = new FileOutputStream(filePath);
        IOUtils.copy((InputStream)input, (OutputStream)output);
        input.close();
        ((OutputStream)output).close();
    }

    public boolean isExternalReport() {
        return false;
    }

    public String getBundleKey() {
        return "jslint";
    }
}

