/*
 * Decompiled with CFR 0.152.
 */
package gr.abiss.mvn.plugins.jstools.web;

import gr.abiss.mvn.plugins.jstools.utils.ClasspathResourceUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.log4j.Logger;

public class JavascriptDependencyFilter
implements Filter {
    private static Logger log = Logger.getLogger(JavascriptDependencyFilter.class);
    protected static Map<String, String> MIME_TYPE_MAPPINGS = new HashMap<String, String>();
    protected static Map<String, byte[]> cache;
    protected static Map<String, byte[]> gzipedCache;
    protected Set<String> allowedExtentions;
    protected String basePath = "/lib/js";
    protected boolean send404 = true;
    private String cacheControl = "max-age=86400";
    protected boolean enableGzip = true;
    private boolean enableGzipCache = true;
    private boolean enableCache = true;

    protected String getMimeTypeFromFileExtention(String extention) {
        String mimeType = null;
        if (extention != null) {
            mimeType = MIME_TYPE_MAPPINGS.get(extention);
        }
        return mimeType;
    }

    private String getFileExtention(String resourcePath) {
        int extensionIndex;
        String extention = null;
        if (resourcePath != null && (extensionIndex = resourcePath.lastIndexOf(46)) != -1 && extensionIndex + 1 < resourcePath.length()) {
            extention = resourcePath.substring(extensionIndex + 1);
        }
        return extention;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String httpMethod = req.getMethod().toUpperCase();
        if (!httpMethod.equalsIgnoreCase("GET") && !httpMethod.equalsIgnoreCase("HEAD")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sent 501: Non Implemented for method: " + httpMethod + ", on resource:" + req.getRequestURI() + ", remote host: " + req.getRemoteHost()));
            }
            res.sendError(501);
        } else {
            String requestURI = req.getRequestURI();
            String resourcePath = this.getResourcePath(requestURI);
            String fileExtention = this.getFileExtention(resourcePath);
            String mimeType = this.getMimeTypeFromFileExtention(fileExtention);
            boolean isText = this.getMimeTypeFromFileExtention(fileExtention).startsWith("text/");
            boolean sendGziped = false;
            String ae = req.getHeader("accept-encoding");
            if (this.enableGzip && isText && ae != null && ae.indexOf("gzip") != -1) {
                sendGziped = true;
            }
            if (this.allowedExtentions.contains(fileExtention.toLowerCase()) && resourcePath.indexOf("META-INF") == -1) {
                byte[] resourceData = null;
                resourceData = sendGziped ? this.getResourceGziped(resourcePath) : this.getResource(resourcePath);
                if (resourceData != null) {
                    res.setHeader("Cache-Control", this.cacheControl);
                    if (mimeType != null) {
                        res.setContentType(mimeType);
                    }
                    if (sendGziped) {
                        res.addHeader("Content-Encoding", "gzip");
                    }
                    res.setContentLength(resourceData.length);
                    ServletOutputStream out = response.getOutputStream();
                    if (httpMethod.equalsIgnoreCase("GET")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Writing resource to response stream, size: " + resourceData.length));
                        }
                        out.write(resourceData);
                    }
                    out.flush();
                    out.close();
                } else if (this.send404) {
                    log.warn((Object)("Sending 404: Not found, for method: " + httpMethod + ", on resource:" + req.getRequestURI() + ", remote host: " + req.getRemoteHost()));
                    res.sendError(404);
                } else {
                    chain.doFilter(request, response);
                }
            } else {
                log.warn((Object)("Sending 501: Forbidden for method: " + httpMethod + ", on resource with disallowed extention:" + req.getRequestURI() + ", remote host: " + req.getRemoteHost()));
                ((HttpServletResponse)response).sendError(403);
            }
        }
    }

    private byte[] getResource(String resourcePath) throws IOException {
        byte[] resource = null;
        if (this.enableCache && cache.containsKey(resourcePath)) {
            resource = cache.get(resourcePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource " + resourcePath + " was loaded from the non-GZIPed cache, size: " + resource.length));
            }
        } else {
            resource = ClasspathResourceUtils.getResourceBytesOrNull(resourcePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource " + resourcePath + " was loaded from the classpath, size: " + resource.length));
            }
            if (this.enableCache) {
                cache.put(resourcePath, (byte[])resource.clone());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resource " + resourcePath + " was added to (non-GZIPed) cache, size: " + resource.length));
                }
            }
            if (this.enableGzipCache) {
                gzipedCache.put(resourcePath, resource != null ? this.toGzipedBytes((byte[])resource.clone()) : resource);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resource " + resourcePath + " was added to the GZIP cache"));
                }
            }
        }
        return resource;
    }

    private byte[] getResourceGziped(String resourcePath) throws IOException {
        byte[] resource = null;
        if (this.enableGzipCache && gzipedCache.containsKey(resourcePath)) {
            resource = gzipedCache.get(resourcePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource " + resourcePath + " was loaded from the GZIP cache, size: " + resource.length));
            }
        } else {
            if (this.enableCache && cache.containsKey(resourcePath)) {
                resource = this.toGzipedBytes(cache.get(resourcePath));
            } else {
                resource = ClasspathResourceUtils.getResourceBytesOrNull(resourcePath);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resource " + resourcePath + " was loaded from the classpath, size: " + resource.length));
                }
                if (this.enableCache) {
                    cache.put(resourcePath, (byte[])resource.clone());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resource " + resourcePath + " was added to (non-GZIPed) cache, size: " + resource.length));
                    }
                }
                resource = this.toGzipedBytes(resource);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resource " + resourcePath + " was GZIPed, size: " + resource.length));
                }
            }
            if (this.enableGzipCache) {
                gzipedCache.put(resourcePath, resource);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Resource " + resourcePath + " was added to the GZIP cache, size: " + resource.length));
                }
            }
        }
        return resource;
    }

    private String getResourcePath(String requestURI) throws ServletException {
        int basePathIndex = requestURI.indexOf(this.basePath);
        if (basePathIndex == -1) {
            throw new ServletException("The value of the basePath init-parameter is incompatible with the filter mapping");
        }
        String resPath = requestURI.substring(basePathIndex + this.basePath.length());
        if (resPath.startsWith("/")) {
            resPath = resPath.substring(1);
        }
        log.info((Object)("Resource path: " + resPath));
        return resPath;
    }

    private byte[] toGzipedBytes(byte[] data) throws IOException {
        byte[] results = null;
        if (data != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(baos);
            out.write(data, 0, data.length);
            out.finish();
            out.close();
            results = baos.toByteArray();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Compressed from " + data.length + " to " + results.length + " bytes"));
            }
        }
        return results;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String _basePath;
        String _send404;
        String _enableCache;
        String _enableGzipCache;
        String _enableGzip;
        String _cacheControl = filterConfig.getInitParameter("cacheControl");
        if (_cacheControl != null) {
            this.cacheControl = _cacheControl;
        }
        if ((_enableGzip = filterConfig.getInitParameter("enableGzip")) != null) {
            this.enableGzip = BooleanUtils.toBoolean((String)_enableGzip);
        }
        if ((_enableGzipCache = filterConfig.getInitParameter("enableGzipCache")) != null) {
            this.enableGzipCache = BooleanUtils.toBoolean((String)_enableGzipCache);
        }
        if ((_enableCache = filterConfig.getInitParameter("enableCache")) != null) {
            this.enableCache = BooleanUtils.toBoolean((String)_enableCache);
        }
        if ((_send404 = filterConfig.getInitParameter("send404")) != null) {
            this.send404 = BooleanUtils.toBoolean((String)_send404);
        }
        if ((_basePath = filterConfig.getInitParameter("basePath")) != null) {
            this.basePath = _basePath;
        }
        while (this.basePath.endsWith("/")) {
            this.basePath = this.basePath.substring(0, this.basePath.length() - 1);
        }
        if (this.basePath == null || this.basePath.length() == 0) {
            throw new ServletException("Invalid value for init-param basePath: " + _basePath);
        }
        this.basePath = _basePath;
        String allowedExt = filterConfig.getInitParameter("allowedExtentions");
        if (allowedExt == null) {
            allowedExt = "js png jpg gif txt html htm xml xsl xslt svg svgz swf";
        }
        String[] allowedArray = allowedExt.replaceAll("\\s{2,}", " ").trim().split(" ");
        this.allowedExtentions = new HashSet<String>();
        for (int i = 0; i < allowedArray.length; ++i) {
            this.allowedExtentions.add(allowedArray[i].toLowerCase());
        }
        log.info((Object)("Configured JavascriptDependencyFilter with send404: " + this.send404 + ", basePath: " + this.basePath + ", cacheControl: " + this.cacheControl + ", enableGzip: " + this.enableGzip + ", enableGzipCache: " + this.enableGzipCache + ", enableCache: " + this.enableCache + ", allowedExtentions: " + allowedExt));
    }

    public void destroy() {
    }

    static {
        MIME_TYPE_MAPPINGS.put("abs", "audio/x-mpeg");
        MIME_TYPE_MAPPINGS.put("ai", "application/postscript");
        MIME_TYPE_MAPPINGS.put("aif", "audio/x-aiff");
        MIME_TYPE_MAPPINGS.put("aifc", "audio/x-aiff");
        MIME_TYPE_MAPPINGS.put("aiff", "audio/x-aiff");
        MIME_TYPE_MAPPINGS.put("aim", "application/x-aim");
        MIME_TYPE_MAPPINGS.put("art", "image/x-jg");
        MIME_TYPE_MAPPINGS.put("asf", "video/x-ms-asf");
        MIME_TYPE_MAPPINGS.put("asx", "video/x-ms-asf");
        MIME_TYPE_MAPPINGS.put("au", "audio/basic");
        MIME_TYPE_MAPPINGS.put("avi", "video/x-msvideo");
        MIME_TYPE_MAPPINGS.put("avx", "video/x-rad-screenplay");
        MIME_TYPE_MAPPINGS.put("bcpio", "application/x-bcpio");
        MIME_TYPE_MAPPINGS.put("bin", "application/octet-stream");
        MIME_TYPE_MAPPINGS.put("bmp", "image/bmp");
        MIME_TYPE_MAPPINGS.put("body", "text/html");
        MIME_TYPE_MAPPINGS.put("cdf", "application/x-cdf");
        MIME_TYPE_MAPPINGS.put("cer", "application/x-x509-ca-cert");
        MIME_TYPE_MAPPINGS.put("class", "application/java");
        MIME_TYPE_MAPPINGS.put("cpio", "application/x-cpio");
        MIME_TYPE_MAPPINGS.put("csh", "application/x-csh");
        MIME_TYPE_MAPPINGS.put("css", "text/css");
        MIME_TYPE_MAPPINGS.put("dib", "image/bmp");
        MIME_TYPE_MAPPINGS.put("doc", "application/msword");
        MIME_TYPE_MAPPINGS.put("dtd", "text/plain");
        MIME_TYPE_MAPPINGS.put("dv", "video/x-dv");
        MIME_TYPE_MAPPINGS.put("dvi", "application/x-dvi");
        MIME_TYPE_MAPPINGS.put("eps", "application/postscript");
        MIME_TYPE_MAPPINGS.put("etx", "text/x-setext");
        MIME_TYPE_MAPPINGS.put("exe", "application/octet-stream");
        MIME_TYPE_MAPPINGS.put("gif", "image/gif");
        MIME_TYPE_MAPPINGS.put("gtar", "application/x-gtar");
        MIME_TYPE_MAPPINGS.put("gz", "application/x-gzip");
        MIME_TYPE_MAPPINGS.put("hdf", "application/x-hdf");
        MIME_TYPE_MAPPINGS.put("hqx", "application/mac-binhex40");
        MIME_TYPE_MAPPINGS.put("htc", "text/x-component");
        MIME_TYPE_MAPPINGS.put("htm", "text/html");
        MIME_TYPE_MAPPINGS.put("html", "text/html");
        MIME_TYPE_MAPPINGS.put("hqx", "application/mac-binhex40");
        MIME_TYPE_MAPPINGS.put("ief", "image/ief");
        MIME_TYPE_MAPPINGS.put("jad", "text/vnd.sun.j2me.app-descriptor");
        MIME_TYPE_MAPPINGS.put("jar", "application/java-archive");
        MIME_TYPE_MAPPINGS.put("java", "text/plain");
        MIME_TYPE_MAPPINGS.put("jnlp", "application/x-java-jnlp-file");
        MIME_TYPE_MAPPINGS.put("jpe", "image/jpeg");
        MIME_TYPE_MAPPINGS.put("jpeg", "image/jpeg");
        MIME_TYPE_MAPPINGS.put("jpg", "image/jpeg");
        MIME_TYPE_MAPPINGS.put("js", "text/javascript");
        MIME_TYPE_MAPPINGS.put("jsf", "text/plain");
        MIME_TYPE_MAPPINGS.put("jspf", "text/plain");
        MIME_TYPE_MAPPINGS.put("kar", "audio/x-midi");
        MIME_TYPE_MAPPINGS.put("latex", "application/x-latex");
        MIME_TYPE_MAPPINGS.put("m3u", "audio/x-mpegurl");
        MIME_TYPE_MAPPINGS.put("mac", "image/x-macpaint");
        MIME_TYPE_MAPPINGS.put("man", "application/x-troff-man");
        MIME_TYPE_MAPPINGS.put("me", "application/x-troff-me");
        MIME_TYPE_MAPPINGS.put("mid", "audio/x-midi");
        MIME_TYPE_MAPPINGS.put("midi", "audio/x-midi");
        MIME_TYPE_MAPPINGS.put("mif", "application/x-mif");
        MIME_TYPE_MAPPINGS.put("mov", "video/quicktime");
        MIME_TYPE_MAPPINGS.put("movie", "video/x-sgi-movie");
        MIME_TYPE_MAPPINGS.put("mp1", "audio/x-mpeg");
        MIME_TYPE_MAPPINGS.put("mp2", "audio/x-mpeg");
        MIME_TYPE_MAPPINGS.put("mp3", "audio/x-mpeg");
        MIME_TYPE_MAPPINGS.put("mpa", "audio/x-mpeg");
        MIME_TYPE_MAPPINGS.put("mpe", "video/mpeg");
        MIME_TYPE_MAPPINGS.put("mpeg", "video/mpeg");
        MIME_TYPE_MAPPINGS.put("mpega", "audio/x-mpeg");
        MIME_TYPE_MAPPINGS.put("mpg", "video/mpeg");
        MIME_TYPE_MAPPINGS.put("mpv2", "video/mpeg2");
        MIME_TYPE_MAPPINGS.put("ms", "application/x-wais-source");
        MIME_TYPE_MAPPINGS.put("nc", "application/x-netcdf");
        MIME_TYPE_MAPPINGS.put("oda", "application/oda");
        MIME_TYPE_MAPPINGS.put("pbm", "image/x-portable-bitmap");
        MIME_TYPE_MAPPINGS.put("pct", "image/pict");
        MIME_TYPE_MAPPINGS.put("pdf", "application/pdf");
        MIME_TYPE_MAPPINGS.put("pgm", "image/x-portable-graymap");
        MIME_TYPE_MAPPINGS.put("pic", "image/pict");
        MIME_TYPE_MAPPINGS.put("pict", "image/pict");
        MIME_TYPE_MAPPINGS.put("pls", "audio/x-scpls");
        MIME_TYPE_MAPPINGS.put("png", "image/png");
        MIME_TYPE_MAPPINGS.put("pnm", "image/x-portable-anymap");
        MIME_TYPE_MAPPINGS.put("pnt", "image/x-macpaint");
        MIME_TYPE_MAPPINGS.put("ppm", "image/x-portable-pixmap");
        MIME_TYPE_MAPPINGS.put("ps", "application/postscript");
        MIME_TYPE_MAPPINGS.put("psd", "image/x-photoshop");
        MIME_TYPE_MAPPINGS.put("qt", "video/quicktime");
        MIME_TYPE_MAPPINGS.put("qti", "image/x-quicktime");
        MIME_TYPE_MAPPINGS.put("qtif", "image/x-quicktime");
        MIME_TYPE_MAPPINGS.put("ras", "image/x-cmu-raster");
        MIME_TYPE_MAPPINGS.put("rgb", "image/x-rgb");
        MIME_TYPE_MAPPINGS.put("rm", "application/vnd.rn-realmedia");
        MIME_TYPE_MAPPINGS.put("roff", "application/x-troff");
        MIME_TYPE_MAPPINGS.put("rtf", "application/rtf");
        MIME_TYPE_MAPPINGS.put("rtx", "text/richtext");
        MIME_TYPE_MAPPINGS.put("sh", "application/x-sh");
        MIME_TYPE_MAPPINGS.put("shar", "application/x-shar");
        MIME_TYPE_MAPPINGS.put("smf", "audio/x-midi");
        MIME_TYPE_MAPPINGS.put("snd", "audio/basic");
        MIME_TYPE_MAPPINGS.put("src", "application/x-wais-source");
        MIME_TYPE_MAPPINGS.put("sv4cpio", "application/x-sv4cpio");
        MIME_TYPE_MAPPINGS.put("sv4crc", "application/x-sv4crc");
        MIME_TYPE_MAPPINGS.put("swf", "application/x-shockwave-flash");
        MIME_TYPE_MAPPINGS.put("t", "application/x-troff");
        MIME_TYPE_MAPPINGS.put("tar", "application/x-tar");
        MIME_TYPE_MAPPINGS.put("tcl", "application/x-tcl");
        MIME_TYPE_MAPPINGS.put("tex", "application/x-tex");
        MIME_TYPE_MAPPINGS.put("texi", "application/x-texinfo");
        MIME_TYPE_MAPPINGS.put("texinfo", "application/x-texinfo");
        MIME_TYPE_MAPPINGS.put("tif", "image/tiff");
        MIME_TYPE_MAPPINGS.put("tiff", "image/tiff");
        MIME_TYPE_MAPPINGS.put("tr", "application/x-troff");
        MIME_TYPE_MAPPINGS.put("tsv", "text/tab-separated-values");
        MIME_TYPE_MAPPINGS.put("txt", "text/plain");
        MIME_TYPE_MAPPINGS.put("ulw", "audio/basic");
        MIME_TYPE_MAPPINGS.put("ustar", "application/x-ustar");
        MIME_TYPE_MAPPINGS.put("xbm", "image/x-xbitmap");
        MIME_TYPE_MAPPINGS.put("xml", "text/xml");
        MIME_TYPE_MAPPINGS.put("xpm", "image/x-xpixmap");
        MIME_TYPE_MAPPINGS.put("xsl", "text/xml");
        MIME_TYPE_MAPPINGS.put("xsd", "text/xml");
        MIME_TYPE_MAPPINGS.put("rng", "text/xml");
        MIME_TYPE_MAPPINGS.put("xwd", "image/x-xwindowdump");
        MIME_TYPE_MAPPINGS.put("wav", "audio/x-wav");
        MIME_TYPE_MAPPINGS.put("svg", "image/svg+xml");
        MIME_TYPE_MAPPINGS.put("svgz", "image/svg+xml");
        MIME_TYPE_MAPPINGS.put("wbmp", "image/vnd.wap.wbmp");
        MIME_TYPE_MAPPINGS.put("wml", "text/vnd.wap.wml");
        MIME_TYPE_MAPPINGS.put("wmlc", "application/vnd.wap.wmlc");
        MIME_TYPE_MAPPINGS.put("wmls", "text/vnd.wap.wmlscript");
        MIME_TYPE_MAPPINGS.put("wmlscriptc", "application/vnd.wap.wmlscriptc");
        MIME_TYPE_MAPPINGS.put("wrl", "x-world/x-vrml");
        MIME_TYPE_MAPPINGS.put("Z", "application/x-compress");
        MIME_TYPE_MAPPINGS.put("z", "application/x-compress");
        MIME_TYPE_MAPPINGS.put("zip", "application/zip");
        MIME_TYPE_MAPPINGS = Collections.unmodifiableMap(MIME_TYPE_MAPPINGS);
        cache = new ConcurrentHashMap<String, byte[]>();
        gzipedCache = new ConcurrentHashMap<String, byte[]>();
    }
}

