/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyRuntimeException;
import groovyjarjarasm.asm.ClassVisitor;
import groovyjarjarasm.asm.ClassWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;

public class GroovyClassLoader
extends SecureClassLoader {
    private Map cache = new HashMap();
    private Collection loadedClasses = null;
    private CompilerConfiguration config;
    private String[] searchPaths;
    private Set additionalPaths = new HashSet();
    static /* synthetic */ Class class$groovy$lang$GroovyObject;

    public void removeFromCache(Class aClass) {
        this.cache.remove(aClass);
    }

    public GroovyClassLoader() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public GroovyClassLoader(ClassLoader loader) {
        this(loader, null);
    }

    public GroovyClassLoader(GroovyClassLoader parent) {
        this(parent, parent.config);
    }

    public GroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
        super(loader);
        if (config == null) {
            config = CompilerConfiguration.DEFAULT;
        }
        this.config = config;
        this.loadedClasses = new ArrayList();
    }

    public Class defineClass(ClassNode classNode, String file) {
        return this.defineClass(classNode, file, "/groovy/defineClass");
    }

    public Class defineClass(ClassNode classNode, String file, String newCodeBase) {
        CodeSource codeSource = null;
        try {
            codeSource = new CodeSource(new URL("file", "", newCodeBase), (Certificate[])null);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        CompilationUnit unit = new CompilationUnit(this.config, codeSource, this.getParent());
        try {
            ClassCollector collector = this.createCollector(unit);
            unit.addClassNode(classNode);
            unit.setClassgenCallback(collector);
            unit.compile(7);
            return collector.generatedClass;
        }
        catch (CompilationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    public Class parseClass(File file) throws CompilationFailedException, IOException {
        return this.parseClass(new GroovyCodeSource(file));
    }

    public Class parseClass(String text, String fileName) throws CompilationFailedException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), fileName);
    }

    public Class parseClass(String text) throws CompilationFailedException {
        return this.parseClass(new ByteArrayInputStream(text.getBytes()), "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(InputStream in) throws CompilationFailedException {
        return this.parseClass(in, "script" + System.currentTimeMillis() + ".groovy");
    }

    public Class parseClass(final InputStream in, final String fileName) throws CompilationFailedException {
        GroovyCodeSource gcs = (GroovyCodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new GroovyCodeSource(in, fileName, "/groovy/script");
            }
        });
        return this.parseClass(gcs);
    }

    public Class parseClass(GroovyCodeSource codeSource) throws CompilationFailedException {
        return this.parseClass(codeSource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class parseClass(GroovyCodeSource codeSource, boolean shouldCache) throws CompilationFailedException {
        Map map;
        String name = codeSource.getName();
        Class answer = null;
        Map map2 = this.cache;
        synchronized (map2) {
            answer = (Class)this.cache.get(name);
            if (answer != null) {
                return answer == PARSING.class ? null : answer;
            }
            this.cache.put(name, PARSING.class);
        }
        try {
            CompilationUnit unit = new CompilationUnit(this.config, codeSource.getCodeSource(), this);
            ClassCollector collector = this.createCollector(unit);
            if (codeSource.getFile() == null) {
                unit.addSource(name, codeSource.getInputStream());
            } else {
                unit.addSource(codeSource.getFile());
            }
            unit.setClassgenCallback(collector);
            int goalPhase = 7;
            if (this.config != null && this.config.getTargetDirectory() != null) {
                goalPhase = 8;
            }
            unit.compile(goalPhase);
            answer = collector.generatedClass;
            Collection collection = this.loadedClasses;
            synchronized (collection) {
                this.loadedClasses.addAll(collector.getLoadedClasses());
            }
            Object var11_11 = null;
            map = this.cache;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            Map map3 = this.cache;
            synchronized (map3) {
                if (answer == null || !shouldCache) {
                    this.cache.remove(name);
                } else {
                    this.cache.put(name, answer);
                }
            }
            try {
                codeSource.getInputStream().close();
            }
            catch (IOException e) {
                throw new GroovyRuntimeException("unable to close stream", e);
            }
            throw throwable;
        }
        synchronized (map) {
            if (answer == null || !shouldCache) {
                this.cache.remove(name);
            } else {
                this.cache.put(name, answer);
            }
        }
        try {
            codeSource.getInputStream().close();
        }
        catch (IOException e) {
            throw new GroovyRuntimeException("unable to close stream", e);
        }
        return answer;
    }

    private byte[] extractBytes(JarFile jarFile, JarEntry entry) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int b;
            BufferedInputStream bis = new BufferedInputStream(jarFile.getInputStream(entry));
            while ((b = bis.read()) != -1) {
                baos.write(b);
            }
        }
        catch (IOException ioe) {
            throw new GroovyRuntimeException("Could not read the jar bytes for " + entry.getName());
        }
        return baos.toByteArray();
    }

    protected String[] getClassPath() {
        if (null == this.searchPaths) {
            String classpath;
            if (null != this.config && null != this.config.getClasspath()) {
                StringBuffer sb = new StringBuffer();
                Iterator iter = this.config.getClasspath().iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next().toString());
                    sb.append(File.pathSeparatorChar);
                }
                sb.deleteCharAt(sb.length() - 1);
                classpath = sb.toString();
            } else {
                classpath = System.getProperty("java.class.path", ".");
            }
            ArrayList pathList = new ArrayList(this.additionalPaths);
            this.expandClassPath(pathList, null, classpath, false);
            this.searchPaths = new String[pathList.size()];
            this.searchPaths = pathList.toArray(this.searchPaths);
        }
        return this.searchPaths;
    }

    protected void expandClassPath(List pathList, String base, String classpath, boolean isManifestClasspath) {
        if (classpath != null) {
            String[] paths = isManifestClasspath ? classpath.split("[\\ ,:;]") : classpath.split(File.pathSeparator);
            for (int i = 0; i < paths.length; ++i) {
                if (paths.length <= 0) continue;
                File path = null;
                path = "".equals(base) ? new File(paths[i]) : new File(base, paths[i]);
                if (!path.exists()) continue;
                if (!path.isDirectory()) {
                    try {
                        Attributes classPathAttributes;
                        String manifestClassPath;
                        JarFile jar = new JarFile(path);
                        pathList.add(paths[i]);
                        Manifest manifest = jar.getManifest();
                        if (manifest == null || (manifestClassPath = (classPathAttributes = manifest.getMainAttributes()).getValue("Class-Path")) == null) continue;
                        this.expandClassPath(pathList, paths[i], manifestClassPath, true);
                    }
                    catch (IOException e) {}
                    continue;
                }
                pathList.add(paths[i]);
            }
        }
    }

    protected Class defineClass(String name, byte[] bytecode, ProtectionDomain domain) {
        return this.defineClass(name, bytecode, 0, bytecode.length, domain);
    }

    protected ClassCollector createCollector(CompilationUnit unit) {
        return new ClassCollector(this, unit);
    }

    public Class defineClass(String name, byte[] b) {
        return super.defineClass(name, b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Class loadClass(final String name, boolean resolve) throws ClassNotFoundException {
        Map map;
        ClassNotFoundException last;
        Class cls;
        block24: {
            String className;
            int i;
            Map map2 = this.cache;
            synchronized (map2) {
                cls = (Class)this.cache.get(name);
                if (cls == NOT_RESOLVED.class) {
                    throw new ClassNotFoundException(name);
                }
                if (cls != null) {
                    return cls;
                }
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && (i = (className = name.replace('/', '.')).lastIndexOf(46)) != -1) {
                sm.checkPackageAccess(className.substring(0, i));
            }
            cls = null;
            last = null;
            try {
                cls = super.loadClass(name, resolve);
                boolean recompile = false;
                if (this.getTimeStamp(cls) < Long.MAX_VALUE) {
                    Class<?>[] inters = cls.getInterfaces();
                    for (int i2 = 0; i2 < inters.length; ++i2) {
                        if (!inters[i2].getName().equals((class$groovy$lang$GroovyObject == null ? GroovyClassLoader.class$("groovy.lang.GroovyObject") : class$groovy$lang$GroovyObject).getName())) continue;
                        recompile = true;
                        break;
                    }
                }
                if (!recompile) {
                    return cls;
                }
            }
            catch (ClassNotFoundException cnfe) {
                last = cnfe;
            }
            try {
                File source = (File)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return GroovyClassLoader.this.getSourceFile(name);
                    }
                });
                if (source == null || (cls == null || !this.isSourceNewer(source, cls)) && cls != null) break block24;
                Map map3 = this.cache;
                synchronized (map3) {
                    this.cache.put(name, PARSING.class);
                }
                cls = this.parseClass(source);
            }
            catch (Exception e) {
                cls = null;
                last = new ClassNotFoundException("Failed to parse groovy file: " + name, e);
            }
        }
        if (cls == null) {
            if (last == null) {
                throw new AssertionError(true);
            }
            map = this.cache;
            synchronized (map) {
                this.cache.put(name, NOT_RESOLVED.class);
            }
            throw last;
        }
        map = this.cache;
        synchronized (map) {
            this.cache.put(name, cls);
        }
        return cls;
    }

    private long getTimeStamp(Class cls) {
        Long o;
        try {
            Field field = cls.getField("__timeStamp");
            o = (Long)field.get(null);
        }
        catch (Exception e) {
            return Long.MAX_VALUE;
        }
        return o;
    }

    private File getSourceFile(String name) {
        File source = null;
        String filename = name.replace('.', '/') + ".groovy";
        String[] paths = this.getClassPath();
        for (int i = 0; i < paths.length; ++i) {
            File file;
            String pathName = paths[i];
            File path = new File(pathName);
            if (!path.exists() || !path.isDirectory() || !(file = new File(path, filename)).exists()) continue;
            boolean fileExists = false;
            int sepp = filename.lastIndexOf(47);
            String fn = filename;
            if (sepp >= 0) {
                fn = filename.substring(++sepp);
            }
            File parent = file.getParentFile();
            String[] files = parent.list();
            for (int j = 0; j < files.length; ++j) {
                if (!files[j].equals(fn)) continue;
                fileExists = true;
                break;
            }
            if (!fileExists) continue;
            source = file;
            break;
        }
        return source;
    }

    private boolean isSourceNewer(File source, Class cls) {
        return source.lastModified() > this.getTimeStamp(cls);
    }

    public void addClasspath(String path) {
        this.additionalPaths.add(path);
        this.searchPaths = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getLoadedClasses() {
        Class[] loadedClasses = null;
        Collection collection = this.loadedClasses;
        synchronized (collection) {
            loadedClasses = this.loadedClasses.toArray(new Class[this.loadedClasses.size()]);
        }
        return loadedClasses;
    }

    public static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        private Class generatedClass;
        private GroovyClassLoader cl;
        private CompilationUnit unit;
        private Collection loadedClasses = null;

        protected ClassCollector(GroovyClassLoader cl, CompilationUnit unit) {
            this.cl = cl;
            this.unit = unit;
            this.loadedClasses = new ArrayList();
        }

        protected Class onClassNode(ClassWriter classWriter, ClassNode classNode) {
            byte[] code = classWriter.toByteArray();
            Class theClass = this.cl.defineClass(classNode.getName(), code, 0, code.length, this.unit.getAST().getCodeSource());
            this.loadedClasses.add(theClass);
            if (this.generatedClass == null) {
                this.generatedClass = theClass;
            }
            return theClass;
        }

        public void call(ClassVisitor classWriter, ClassNode classNode) {
            this.onClassNode((ClassWriter)classWriter, classNode);
        }

        public Collection getLoadedClasses() {
            return this.loadedClasses;
        }
    }

    private class NOT_RESOLVED {
        private NOT_RESOLVED() {
        }
    }

    public static class PARSING {
    }
}

