/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.GroovyObject;
import groovy.lang.MissingClassException;
import groovy.lang.Script;
import groovyjarjarasm.asm.Opcodes;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.CompileUnit;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.MixinNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.ClassGeneratorException;

public class ClassNode
extends AnnotatedNode
implements Opcodes {
    private static final String[] defaultImports = new String[]{"java.lang", "java.util", "groovy.lang", "groovy.util"};
    private transient Logger log = Logger.getLogger(this.getClass().getName());
    private String name;
    private int modifiers;
    private String superClass;
    private String[] interfaces;
    private MixinNode[] mixins;
    private List constructors = new ArrayList();
    private List methods = new ArrayList();
    private List fields = new ArrayList();
    private List properties = new ArrayList();
    private Map fieldIndex = new HashMap();
    private ModuleNode module;
    private CompileUnit compileUnit;
    private boolean staticClass = false;
    private boolean scriptBody = false;
    private boolean script;
    private ClassNode superClassNode;
    private MethodNode enclosingMethod = null;

    public MethodNode getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public void setEnclosingMethod(MethodNode enclosingMethod) {
        this.enclosingMethod = enclosingMethod;
    }

    public ClassNode(String name, int modifiers, String superClass) {
        this(name, modifiers, superClass, EMPTY_STRING_ARRAY, MixinNode.EMPTY_ARRAY);
    }

    public ClassNode(String name, int modifiers, String superClass, String[] interfaces, MixinNode[] mixins) {
        this.name = name;
        this.modifiers = modifiers;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.mixins = mixins;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public List getFields() {
        return this.fields;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public MixinNode[] getMixins() {
        return this.mixins;
    }

    public List getMethods() {
        return this.methods;
    }

    public List getAbstractMethods() {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        Iterator methIt = this.getAllDeclaredMethods().iterator();
        while (methIt.hasNext()) {
            MethodNode method = (MethodNode)methIt.next();
            if (!method.isAbstract()) continue;
            result.add(method);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public List getAllDeclaredMethods() {
        return new ArrayList(this.getDeclaredMethodsMap().values());
    }

    protected Map getDeclaredMethodsMap() {
        ClassNode parent = this.getSuperClassNode();
        HashMap<String, MethodNode> result = null;
        result = parent != null ? parent.getDeclaredMethodsMap() : new HashMap<String, MethodNode>();
        for (int i = 0; i < this.interfaces.length; ++i) {
            String interfaceName = this.interfaces[i];
            ClassNode iface = this.findClassNode(interfaceName);
            Map ifaceMethodsMap = iface.getDeclaredMethodsMap();
            Iterator iter = ifaceMethodsMap.keySet().iterator();
            while (iter.hasNext()) {
                String methSig = (String)iter.next();
                if (result.containsKey(methSig)) continue;
                MethodNode methNode = (MethodNode)ifaceMethodsMap.get(methSig);
                result.put(methSig, methNode);
            }
        }
        Iterator iter = this.getMethods().iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            String sig = method.getTypeDescriptor();
            if (result.containsKey(sig)) {
                MethodNode inheritedMethod = (MethodNode)result.get(sig);
                if (!inheritedMethod.isAbstract()) continue;
                result.put(sig, method);
                continue;
            }
            result.put(sig, method);
        }
        return result;
    }

    protected int findMatchingMethodInList(MethodNode method, List methods) {
        for (int i = 0; i < methods.size(); ++i) {
            MethodNode someMeth = (MethodNode)methods.get(i);
            if (!someMeth.getName().equals(method.getName()) || !this.parametersEqual(someMeth.getParameters(), method.getParameters())) continue;
            return i;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public List getProperties() {
        return this.properties;
    }

    public List getDeclaredConstructors() {
        return this.constructors;
    }

    public ModuleNode getModule() {
        return this.module;
    }

    public void setModule(ModuleNode module) {
        this.module = module;
        if (module != null) {
            this.compileUnit = module.getUnit();
        }
    }

    public void addField(FieldNode node) {
        node.setDeclaringClass(this);
        node.setOwner(this.getName());
        this.fields.add(node);
        this.fieldIndex.put(node.getName(), node);
    }

    public void addProperty(PropertyNode node) {
        node.setDeclaringClass(this);
        FieldNode field = node.getField();
        this.addField(field);
        this.properties.add(node);
    }

    public PropertyNode addProperty(String name, int modifiers, String type, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        PropertyNode node = new PropertyNode(name, modifiers, type, this.getName(), initialValueExpression, getterBlock, setterBlock);
        this.addProperty(node);
        return node;
    }

    public void addConstructor(ConstructorNode node) {
        node.setDeclaringClass(this);
        this.constructors.add(node);
    }

    public ConstructorNode addConstructor(int modifiers, Parameter[] parameters, Statement code) {
        ConstructorNode node = new ConstructorNode(modifiers, parameters, code);
        this.addConstructor(node);
        return node;
    }

    public void addMethod(MethodNode node) {
        node.setDeclaringClass(this);
        this.methods.add(node);
    }

    public MethodNode addMethod(String name, int modifiers, String returnType, Parameter[] parameters, Statement code) {
        MethodNode other = this.getDeclaredMethod(name, parameters);
        if (other != null) {
            return other;
        }
        MethodNode node = new MethodNode(name, modifiers, returnType, parameters, code);
        this.addMethod(node);
        return node;
    }

    public MethodNode addSyntheticMethod(String name, int modifiers, String returnType, Parameter[] parameters, Statement code) {
        MethodNode answer = this.addMethod(name, modifiers, returnType, parameters, code);
        answer.setSynthetic(true);
        return answer;
    }

    public FieldNode addField(String name, int modifiers, String type, Expression initialValue) {
        FieldNode node = new FieldNode(name, modifiers, type, this.getName(), initialValue);
        this.addField(node);
        return node;
    }

    public void addInterface(String name) {
        boolean skip = false;
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (!name.equals(this.interfaces[i])) continue;
            skip = true;
        }
        if (!skip) {
            String[] newInterfaces = new String[this.interfaces.length + 1];
            System.arraycopy(this.interfaces, 0, newInterfaces, 0, this.interfaces.length);
            newInterfaces[this.interfaces.length] = name;
            this.interfaces = newInterfaces;
        }
    }

    public void addMixin(MixinNode mixin) {
        boolean skip = false;
        String mixinName = mixin.getName();
        for (int i = 0; i < this.mixins.length; ++i) {
            if (!mixinName.equals(this.mixins[i].getName())) continue;
            skip = true;
        }
        if (!skip) {
            MixinNode[] newMixins = new MixinNode[this.mixins.length + 1];
            System.arraycopy(this.mixins, 0, newMixins, 0, this.mixins.length);
            newMixins[this.mixins.length] = mixin;
            this.mixins = newMixins;
        }
    }

    public FieldNode getField(String name) {
        return (FieldNode)this.fieldIndex.get(name);
    }

    public FieldNode getOuterField(String name) {
        return null;
    }

    public ClassNode getOuterClass() {
        return null;
    }

    public void addStaticInitializerStatements(List staticStatements) {
        MethodNode method = null;
        List declaredMethods = this.getDeclaredMethods("<clinit>");
        if (declaredMethods.isEmpty()) {
            method = this.addMethod("<clinit>", 9, "void", Parameter.EMPTY_ARRAY, new BlockStatement());
            method.setSynthetic(true);
        } else {
            method = (MethodNode)declaredMethods.get(0);
        }
        BlockStatement block = null;
        Statement statement = method.getCode();
        if (statement == null) {
            block = new BlockStatement();
        } else if (statement instanceof BlockStatement) {
            block = (BlockStatement)statement;
        } else {
            block = new BlockStatement();
            block.addStatement(statement);
        }
        block.addStatements(staticStatements);
    }

    public List getDeclaredMethods(String name) {
        ArrayList<MethodNode> answer = new ArrayList<MethodNode>();
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!name.equals(method.getName())) continue;
            answer.add(method);
        }
        return answer;
    }

    public List getMethods(String name) {
        ArrayList<MethodNode> answer = new ArrayList<MethodNode>();
        ClassNode node = this;
        do {
            Iterator iter = node.methods.iterator();
            while (iter.hasNext()) {
                MethodNode method = (MethodNode)iter.next();
                if (!name.equals(method.getName())) continue;
                answer.add(method);
            }
        } while ((node = node.getSuperClassNode()) != null);
        return answer;
    }

    public MethodNode getDeclaredMethod(String name, Parameter[] parameters) {
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!name.equals(method.getName()) || !this.parametersEqual(method.getParameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    public boolean isDerivedFrom(String name) {
        for (ClassNode node = this.getSuperClassNode(); node != null; node = node.getSuperClassNode()) {
            if (!name.equals(node.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isDerivedFromGroovyObject() {
        return this.implementsInteface(GroovyObject.class.getName());
    }

    public boolean implementsInteface(String name) {
        ClassNode node = this;
        do {
            if (!node.declaresInterface(name)) continue;
            return true;
        } while ((node = node.getSuperClassNode()) != null);
        return false;
    }

    public boolean declaresInterface(String name) {
        int size = this.interfaces.length;
        for (int i = 0; i < size; ++i) {
            if (!name.equals(this.interfaces[i])) continue;
            return true;
        }
        return false;
    }

    public ClassNode getSuperClassNode() {
        if (this.superClass != null && this.superClass.length() > 0 && this.superClassNode == null && !this.name.equals("java.lang.Object")) {
            String temp = this.resolveClassName(this.superClass);
            if (temp == null) {
                throw new MissingClassException(this.superClass, this, "No such superclass");
            }
            this.superClass = temp;
            this.superClassNode = this.findClassNode(this.superClass);
        }
        return this.superClassNode;
    }

    public ClassNode findClassNode(String type) {
        ClassNode answer = null;
        CompileUnit theCompileUnit = this.getCompileUnit();
        if (theCompileUnit != null && (answer = theCompileUnit.getClass(type)) == null) {
            try {
                Class theClass = theCompileUnit.loadClass(type);
                answer = this.createClassNode(theClass);
            }
            catch (ClassNotFoundException e) {
                this.log.log(Level.WARNING, "Cannot find class: " + type, e);
            }
        }
        return answer;
    }

    protected ClassNode createClassNode(Class theClass) {
        Class<?>[] classInterfaces = theClass.getInterfaces();
        int size = classInterfaces.length;
        String[] interfaceNames = new String[size];
        for (int i = 0; i < size; ++i) {
            interfaceNames[i] = classInterfaces[i].getName();
        }
        String className = null;
        if (theClass.getSuperclass() != null) {
            className = theClass.getSuperclass().getName();
        }
        ClassNode answer = new ClassNode(theClass.getName(), theClass.getModifiers(), className, interfaceNames, MixinNode.EMPTY_ARRAY);
        answer.compileUnit = this.getCompileUnit();
        Method[] declaredMethods = theClass.getDeclaredMethods();
        for (int i = 0; i < declaredMethods.length; ++i) {
            answer.addMethod(this.createMethodNode(declaredMethods[i]));
        }
        Constructor<?>[] declaredConstructors = theClass.getDeclaredConstructors();
        for (int i = 0; i < declaredConstructors.length; ++i) {
            answer.addConstructor(this.createConstructorNode(declaredConstructors[i]));
        }
        return answer;
    }

    private ConstructorNode createConstructorNode(Constructor constructor) {
        Parameter[] parameters = this.createParameters(constructor.getParameterTypes());
        return new ConstructorNode(constructor.getModifiers(), parameters, EmptyStatement.INSTANCE);
    }

    protected MethodNode createMethodNode(Method method) {
        Parameter[] parameters = this.createParameters(method.getParameterTypes());
        return new MethodNode(method.getName(), method.getModifiers(), method.getReturnType().getName(), parameters, EmptyStatement.INSTANCE);
    }

    protected Parameter[] createParameters(Class[] types) {
        Parameter[] parameters = Parameter.EMPTY_ARRAY;
        int size = types.length;
        if (size > 0) {
            parameters = new Parameter[size];
            for (int i = 0; i < size; ++i) {
                parameters[i] = this.createParameter(types[i], i);
            }
        }
        return parameters;
    }

    protected Parameter createParameter(Class parameterType, int idx) {
        return new Parameter(parameterType.getName(), "param" + idx);
    }

    public String resolveClassName(String type) {
        String answer = null;
        if (type != null) {
            if (this.getName().equals(type) || this.getNameWithoutPackage().equals(type)) {
                return this.getName();
            }
            answer = this.tryResolveClassAndInnerClass(type);
            String replacedPointType = type;
            while (answer == null && replacedPointType.indexOf(46) > -1) {
                int lastPoint = replacedPointType.lastIndexOf(46);
                replacedPointType = replacedPointType.substring(0, lastPoint) + "$" + replacedPointType.substring(lastPoint + 1);
                answer = this.tryResolveClassAndInnerClass(replacedPointType);
            }
        }
        return answer;
    }

    private String tryResolveClassAndInnerClass(String type) {
        String packageName;
        String answer = this.tryResolveClassFromCompileUnit(type);
        if (answer == null && (packageName = this.getPackageName()) != null && packageName.length() > 0) {
            answer = this.tryResolveClassFromCompileUnit(packageName + "." + type);
        }
        if (answer == null && this.module != null) {
            Iterator iter = this.module.getImportPackages().iterator();
            while (iter.hasNext()) {
                String packageName2 = (String)iter.next();
                answer = this.tryResolveClassFromCompileUnit(packageName2 + type);
                if (answer == null) continue;
                return answer;
            }
        }
        if (answer == null) {
            int size = defaultImports.length;
            for (int i = 0; i < size; ++i) {
                String packagePrefix = defaultImports[i];
                answer = this.tryResolveClassFromCompileUnit(packagePrefix + "." + type);
                if (answer == null) continue;
                return answer;
            }
        }
        return answer;
    }

    protected String tryResolveClassFromCompileUnit(String type) {
        CompileUnit theCompileUnit = this.getCompileUnit();
        if (theCompileUnit != null) {
            if (theCompileUnit.getClass(type) != null) {
                return type;
            }
            try {
                theCompileUnit.loadClass(type);
                return type;
            }
            catch (AccessControlException ace) {
                throw ace;
            }
            catch (ClassGeneratorException cge) {
                throw cge;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public CompileUnit getCompileUnit() {
        if (this.compileUnit == null && this.module != null) {
            this.compileUnit = this.module.getUnit();
        }
        return this.compileUnit;
    }

    protected boolean parametersEqual(Parameter[] a, Parameter[] b) {
        if (a.length == b.length) {
            boolean answer = true;
            for (int i = 0; i < a.length; ++i) {
                if (a[i].getType().equals(b[i].getType())) continue;
                answer = false;
                break;
            }
            return answer;
        }
        return false;
    }

    public String getClassNameForExpression(String identifier) {
        String className = null;
        if (this.module != null) {
            className = this.module.getImport(identifier);
            if (className == null) {
                if (this.module.getUnit().getClass(identifier) != null) {
                    className = identifier;
                } else {
                    String packageName = this.getPackageName();
                    if (packageName != null) {
                        String guessName = packageName + "." + identifier;
                        if (this.module.getUnit().getClass(guessName) != null) {
                            className = guessName;
                        } else if (guessName.equals(this.name)) {
                            className = this.name;
                        }
                    }
                }
            }
        } else {
            System.out.println("No module for class: " + this.getName());
        }
        return className;
    }

    public String getPackageName() {
        int idx = this.name.lastIndexOf(46);
        if (idx > 0) {
            return this.name.substring(0, idx);
        }
        return null;
    }

    public String getNameWithoutPackage() {
        int idx = this.name.lastIndexOf(46);
        if (idx > 0) {
            return this.name.substring(idx + 1);
        }
        return this.name;
    }

    public void visitContents(GroovyClassVisitor visitor) {
        Iterator iter = this.getProperties().iterator();
        while (iter.hasNext()) {
            visitor.visitProperty((PropertyNode)iter.next());
        }
        iter = this.getFields().iterator();
        while (iter.hasNext()) {
            visitor.visitField((FieldNode)iter.next());
        }
        iter = this.getDeclaredConstructors().iterator();
        while (iter.hasNext()) {
            visitor.visitConstructor((ConstructorNode)iter.next());
        }
        iter = this.getMethods().iterator();
        while (iter.hasNext()) {
            visitor.visitMethod((MethodNode)iter.next());
        }
    }

    public MethodNode getGetterMethod(String getterName) {
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!getterName.equals(method.getName()) || "void".equals(method.getReturnType()) || method.getParameters().length != 0) continue;
            return method;
        }
        return null;
    }

    public MethodNode getSetterMethod(String getterName) {
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            if (!getterName.equals(method.getName()) || !"void".equals(method.getReturnType()) || method.getParameters().length != 1) continue;
            return method;
        }
        return null;
    }

    public boolean isStaticClass() {
        return this.staticClass;
    }

    public void setStaticClass(boolean staticClass) {
        this.staticClass = staticClass;
    }

    public boolean isScriptBody() {
        return this.scriptBody;
    }

    public void setScriptBody(boolean scriptBody) {
        this.scriptBody = scriptBody;
    }

    public boolean isScript() {
        return this.script | this.isDerivedFrom(Script.class.getName());
    }

    public void setScript(boolean script) {
        this.script = script;
    }

    public String toString() {
        return super.toString() + "[name: " + this.name + "]";
    }

    public boolean hasPossibleMethod(String name, Expression arguments) {
        int count = 0;
        if (arguments instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)arguments;
            count = tuple.getExpressions().size();
        }
        ClassNode node = this;
        do {
            Iterator iter = node.methods.iterator();
            while (iter.hasNext()) {
                MethodNode method = (MethodNode)iter.next();
                if (!name.equals(method.getName()) || method.getParameters().length != count) continue;
                return true;
            }
        } while ((node = node.getSuperClassNode()) != null);
        return false;
    }

    public boolean isInterface() {
        return (this.getModifiers() & 0x200) > 0;
    }
}

