/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovyjarjarasm.asm.Opcodes;
import java.lang.reflect.Field;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.BytecodeHelper;

public class FieldNode
extends AnnotatedNode
implements Opcodes {
    private String name;
    private int modifiers;
    private String type;
    private String owner;
    private Expression initialValueExpression;
    private boolean dynamicType;
    private boolean holder;

    public static FieldNode newStatic(Class theClass, String name) throws SecurityException, NoSuchFieldException {
        Field field = theClass.getField(name);
        String fldType = field.getType().getName();
        return new FieldNode(name, 9, fldType, theClass.getName(), null);
    }

    public FieldNode(String name, int modifiers, String type, ClassNode owner, Expression initialValueExpression) {
        this(name, modifiers, type, owner.getName(), initialValueExpression);
    }

    public FieldNode(String name, int modifiers, String type, String owner, Expression initialValueExpression) {
        this.name = name;
        this.modifiers = modifiers;
        this.type = type;
        this.owner = owner;
        this.initialValueExpression = initialValueExpression;
        if (type == null || type.length() == 0) {
            String initType;
            this.dynamicType = true;
            this.type = initialValueExpression != null ? ((initType = initialValueExpression.getType()) != null && initType.length() > 0 ? initType : "java.lang.Object") : "java.lang.Object";
        } else {
            String boxedType;
            this.type = boxedType = BytecodeHelper.getObjectTypeForPrimitive(type);
            this.dynamicType = false;
        }
    }

    public Expression getInitialValueExpression() {
        return this.initialValueExpression;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isHolder() {
        return this.holder;
    }

    public void setHolder(boolean holder) {
        this.holder = holder;
    }

    public boolean isDynamicType() {
        return this.dynamicType;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }
}

