/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class VariableExpression
extends Expression
implements Variable {
    public static final VariableExpression THIS_EXPRESSION = new VariableExpression("this", ClassHelper.DYNAMIC_TYPE);
    public static final VariableExpression SUPER_EXPRESSION = new VariableExpression("super", ClassHelper.DYNAMIC_TYPE);
    private String variable;
    private boolean inStaticContext;
    private boolean isDynamicTyped = false;

    public VariableExpression(String variable, ClassNode type) {
        this.variable = variable;
        super.setType(ClassHelper.getWrapper(type));
    }

    public VariableExpression(String variable) {
        this(variable, ClassHelper.DYNAMIC_TYPE);
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitVariableExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    public String getText() {
        return this.variable;
    }

    public String getName() {
        return this.variable;
    }

    public String toString() {
        return super.toString() + "[variable: " + this.variable + (this.isDynamicTyped() ? "" : " type: " + this.getType()) + "]";
    }

    public Expression getInitialExpression() {
        return null;
    }

    public boolean hasInitialExpression() {
        return false;
    }

    public boolean isInStaticContext() {
        return this.inStaticContext;
    }

    public void setInStaticContext(boolean inStaticContext) {
        this.inStaticContext = inStaticContext;
    }

    public void setType(ClassNode cn) {
        super.setType(cn);
        this.isDynamicTyped |= ClassHelper.DYNAMIC_TYPE == cn;
    }

    public boolean isDynamicTyped() {
        return this.isDynamicTyped;
    }
}

