/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.EndLabel;
import guru.nidi.graphviz.attribute.ForAll;
import guru.nidi.graphviz.attribute.MapAttributes;
import guru.nidi.graphviz.attribute.SimpleLabel;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public final class Label
extends SimpleLabel
implements Attributes<ForAll> {
    private final boolean external;
    private final boolean floating;
    private final boolean decorated;
    @Nullable
    private final Justification just;
    @Nullable
    private final Location loc;

    private Label(String value, boolean html, boolean external, boolean floating, boolean decorated, @Nullable Justification just, @Nullable Location loc) {
        super(value, html);
        this.external = external;
        this.floating = floating;
        this.decorated = decorated;
        this.just = just;
        this.loc = loc;
    }

    public static Label of(String value) {
        return new Label(value, false, false, false, false, null, null);
    }

    public static Label lines(String ... lines) {
        return Label.lines(Justification.MIDDLE, lines);
    }

    public static Label lines(Justification just, String ... lines) {
        String sep = just == Justification.LEFT ? "\\l" : (just == Justification.RIGHT ? "\\r" : "\n");
        String value = Stream.of(lines).map(line -> line + sep).collect(Collectors.joining());
        return new Label(value, false, false, false, false, null, null);
    }

    public static Label html(String value) {
        return new Label(value, true, false, false, false, null, null);
    }

    public static Label htmlLines(String ... lines) {
        return Label.htmlLines(Justification.MIDDLE, lines);
    }

    public static Label htmlLines(Justification just, String ... lines) {
        String sep = just == Justification.LEFT ? "<br align=\"left\"/>" : (just == Justification.RIGHT ? "<br align=\"right\"/>" : "<br/>");
        String value = Stream.of(lines).map(line -> line + sep).collect(Collectors.joining());
        return new Label(value, true, false, false, false, null, null);
    }

    public static Label markdown(String value) {
        return Label.html(Label.replaceMd(Label.replaceMd(Label.replaceMd(Label.replaceMd(Label.replaceMd(Label.replaceMd(Label.replaceMd(value.replace("\n", "<br/>"), "\\*\\*", "b"), "\\*", "i"), "~~", "s"), "__", "sub"), "_", "u"), "\\^\\^", "sup"), "\\^", "o").replaceAll("\\\\([*~_^])", "$1"));
    }

    private static String replaceMd(String s, String from, String to) {
        return s.replaceAll("([^\\\\])?" + from + "(.*?[^\\\\])" + from, "$1<" + to + ">$2</" + to + ">");
    }

    public static Label raw(String value) {
        boolean isTagged;
        boolean bl = isTagged = value.startsWith("<") && value.endsWith(">");
        if (!isTagged) {
            return Label.of(value);
        }
        String untagged = value.substring(1, value.length() - 1);
        boolean hasTags = value.contains("/>") || value.contains("</");
        return hasTags ? Label.html(untagged) : Label.markdown(untagged);
    }

    public EndLabel head() {
        return EndLabel.head(this, null, null);
    }

    public EndLabel head(double angle, double distance) {
        return EndLabel.head(this, angle, distance);
    }

    public EndLabel tail() {
        return EndLabel.tail(this, null, null);
    }

    public EndLabel tail(double angle, double distance) {
        return EndLabel.tail(this, angle, distance);
    }

    public Label external() {
        return new Label(this.value, this.html, true, this.floating, this.decorated, this.just, this.loc);
    }

    public Label floating() {
        return new Label(this.value, this.html, this.external, true, this.decorated, this.just, this.loc);
    }

    public Label decorated() {
        return new Label(this.value, this.html, this.external, this.floating, true, this.just, this.loc);
    }

    public Label justify(Justification just) {
        return new Label(this.value, this.html, this.external, this.floating, this.decorated, just, this.loc);
    }

    public Label locate(Location loc) {
        return new Label(this.value, this.html, this.external, this.floating, this.decorated, this.just, loc);
    }

    public boolean isExternal() {
        return this.external;
    }

    @Override
    public Attributes<? super ForAll> applyTo(MapAttributes<? super ForAll> attributes) {
        attributes.add(this.external ? "xlabel" : "label", this);
        if (this.floating) {
            attributes.add("labelfloat", true);
        }
        if (this.decorated) {
            attributes.add("decorate", true);
        }
        if (this.just == Justification.LEFT) {
            attributes.add("labeljust", "l");
        }
        if (this.just == Justification.RIGHT) {
            attributes.add("labeljust", "r");
        }
        if (this.loc == Location.TOP) {
            attributes.add("labelloc", "t");
        }
        if (this.loc == Location.BOTTOM) {
            attributes.add("labelloc", "b");
        }
        return attributes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Label label = (Label)o;
        return this.external == label.external && this.floating == label.floating && this.decorated == label.decorated && this.just == label.just && this.loc == label.loc;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.external, this.floating, this.decorated, this.just, this.loc});
    }

    @Override
    public String toString() {
        return this.value;
    }

    public static enum Location {
        TOP,
        CENTER,
        BOTTOM;

    }

    public static enum Justification {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

