/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Format {
    PNG("svg", "png", true, true){

        @Override
        String postProcess(String result, double fontAdjust) {
            return Format.postProcessSvg(result, true, fontAdjust);
        }
    }
    ,
    SVG("svg", "svg", false, true){

        @Override
        String postProcess(String result, double fontAdjust) {
            return Format.postProcessSvg(result, true, fontAdjust);
        }
    }
    ,
    SVG_STANDALONE("svg", "svg", false, true){

        @Override
        String postProcess(String result, double fontAdjust) {
            return Format.postProcessSvg(result, false, fontAdjust);
        }
    }
    ,
    XDOT("xdot", "xdot", false, false),
    PLAIN("plain", "txt", false, false),
    PLAIN_EXT("plain-ext", "txt", false, false),
    PS("ps", "ps", false, false),
    PS2("ps2", "ps", false, false),
    JSON("json", "json", false, false),
    JSON0("json0", "json", false, false);

    private static final Pattern FONT_PATTERN;
    final String vizName;
    final String fileExtension;
    final boolean image;
    final boolean svg;

    private Format(String vizName, String fileExtension, boolean image, boolean svg) {
        this.vizName = vizName;
        this.fileExtension = fileExtension;
        this.image = image;
        this.svg = svg;
    }

    String postProcess(String result, double fontAdjust) {
        return result;
    }

    private static String postProcessSvg(String result, boolean prefix, double fontAdjust) {
        String prefixed = prefix ? Format.withoutPrefix(result) : result;
        return fontAdjust == 1.0 ? prefixed : Format.fontAdjusted(prefixed, fontAdjust);
    }

    private static String withoutPrefix(String svg) {
        int pos = svg.indexOf("<svg ");
        return pos < 0 ? svg : svg.substring(pos);
    }

    private static String fontAdjusted(String svg, double fontAdjust) {
        Matcher m = FONT_PATTERN.matcher(svg);
        StringBuffer s = new StringBuffer();
        while (m.find()) {
            String rep;
            try {
                rep = "font-size=\"" + Double.parseDouble(m.group(1)) * fontAdjust + "\"";
            }
            catch (NumberFormatException e) {
                rep = m.group();
            }
            m.appendReplacement(s, rep);
        }
        m.appendTail(s);
        return s.toString();
    }

    static {
        FONT_PATTERN = Pattern.compile("font-size=\"(.*?)\"");
    }
}

