/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.rough;

import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.GraphvizLoader;
import guru.nidi.graphviz.engine.GraphvizPostProcessor;
import guru.nidi.graphviz.engine.JavascriptEngine;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.ProcessOptions;
import guru.nidi.graphviz.engine.V8JavascriptEngine;
import guru.nidi.graphviz.rough.FillStyle;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Roughifyer
implements GraphvizPostProcessor {
    private static final String CODE = Roughifyer.readCode();
    private static final Pattern FONT_PATTERN = Pattern.compile("font-family=\"(.*?)\"");
    private final JavascriptEngine engine;
    private final List<Map.Entry<Pattern, String>> fonts;
    private final Map<String, Object> options;

    public Roughifyer() {
        this((JavascriptEngine)new V8JavascriptEngine());
    }

    public Roughifyer(JavascriptEngine engine) {
        this(engine, new ArrayList<Map.Entry<Pattern, String>>(), new HashMap<String, Object>());
        engine.executeJavascript(CODE);
    }

    private Roughifyer(JavascriptEngine engine, List<Map.Entry<Pattern, String>> fonts, Map<String, Object> options) {
        this.engine = engine;
        this.options = options;
        this.fonts = fonts;
    }

    public Roughifyer font(String from, String to) {
        ArrayList<Map.Entry<Pattern, String>> fs = new ArrayList<Map.Entry<Pattern, String>>(this.fonts);
        fs.add(new AbstractMap.SimpleEntry<Pattern, String>(Pattern.compile(from.replace("*", ".*?"), 2), to));
        return new Roughifyer(this.engine, fs, this.options);
    }

    public Roughifyer roughness(double roughness) {
        return new Roughifyer(this.engine, this.fonts, this.options("roughness", roughness));
    }

    public Roughifyer bowing(double bowing) {
        return new Roughifyer(this.engine, this.fonts, this.options("bowing", bowing));
    }

    public Roughifyer fillStyle(FillStyle fillStyle) {
        return new Roughifyer(this.engine, this.fonts, this.options("fillStyle", fillStyle));
    }

    public Roughifyer curveStepCount(double curveStepCount) {
        return new Roughifyer(this.engine, this.fonts, this.options("curveStepCount", curveStepCount));
    }

    private Map<String, Object> options(String key, Object value) {
        HashMap<String, Object> os = new HashMap<String, Object>(this.options);
        os.put(key, value);
        return os;
    }

    public EngineResult postProcess(EngineResult result, Options options, ProcessOptions processOptions) {
        if (options.format != Format.SVG && options.format != Format.SVG_STANDALONE && options.format != Format.PNG) {
            return result;
        }
        return EngineResult.fromString((String)this.transform((String)result.map(this::read, s -> s)));
    }

    private String read(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new GraphvizException("Error reading file", (Throwable)e);
        }
    }

    private String transform(String svg) {
        return this.engine.executeJavascript("try{ result(rough(", this.replaceFonts(svg), ",{" + this.optionString(this.options) + "})); } catch(e){ error(e.toString()); };");
    }

    private String optionString(Map<String, Object> options) {
        return options.entrySet().stream().map(e -> this.optionValue((String)e.getKey(), e.getValue())).collect(Collectors.joining(","));
    }

    private String optionValue(String key, Object value) {
        if (value instanceof Number) {
            return key + ":" + value.toString();
        }
        if (value instanceof FillStyle) {
            return this.optionString(((FillStyle)value).values);
        }
        return key + ":\"" + value + "\"";
    }

    private String replaceFonts(String svg) {
        Matcher m = FONT_PATTERN.matcher(svg);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String r = this.replaceFont(m.group(1));
            m.appendReplacement(sb, "font-family=\"" + (r == null ? m.group(1) : r) + "\"");
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String replaceFont(String font) {
        for (Map.Entry<Pattern, String> f : this.fonts) {
            if (!f.getKey().matcher(font).matches()) continue;
            return f.getValue();
        }
        return null;
    }

    private static String readCode() {
        return GraphvizLoader.loadAsString((String)"graphviz-rough.js");
    }
}

