/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.extensions.scribunto.engine;

import info.bliki.extensions.scribunto.engine.ScribuntoEngine;
import info.bliki.wiki.filter.ParsedPageName;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.WikiModelContentException;
import info.bliki.wiki.namespaces.INamespace;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScribuntoEngineBase
implements ScribuntoEngine {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final IWikiModel model;
    private final INamespace.INamespaceValue moduleNamespace;

    protected ScribuntoEngineBase(IWikiModel model) {
        this.model = model;
        this.moduleNamespace = model.getNamespace().getModule();
    }

    protected ParsedPageName pageNameForModule(String moduleName) {
        if (moduleName.toLowerCase().startsWith(this.moduleNamespace.getPrimaryText().toLowerCase() + ":")) {
            return ParsedPageName.parsePageName(this.model, moduleName, this.moduleNamespace, false, false);
        }
        return new ParsedPageName(this.moduleNamespace, moduleName, true);
    }

    protected InputStream getRawWikiContentStream(ParsedPageName pageName) throws FileNotFoundException {
        return new ByteArrayInputStream(this.getRawWikiContent(pageName).getBytes(UTF8));
    }

    protected String getRawWikiContent(ParsedPageName pageName) throws FileNotFoundException {
        try {
            String content = this.model.getRawWikiContent(pageName, null);
            if (content == null) {
                throw new FileNotFoundException("getRawWikiContent returned null");
            }
            return content;
        }
        catch (WikiModelContentException wikiModelContentException) {
            throw new FileNotFoundException("could not find module " + pageName);
        }
    }
}

