/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.ParsedPageName;
import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.WikiModelContentException;
import info.bliki.wiki.namespaces.INamespace;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class Safesubst
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Safesubst();

    @Override
    public String parseFunction(List<String> parts1, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) {
        String substArg = new String(src, beginIndex, endIndex - beginIndex);
        String substituted = Safesubst.parsePreprocess(substArg, model, null);
        char[] src2 = substituted.toCharArray();
        Object[] objs = TemplateParser.createParameterMap(src2, 0, src2.length);
        List parts = (List)objs[0];
        String templateName = (String)objs[1];
        int currOffset = TemplateParser.checkParserFunction(substituted);
        if (currOffset > 0) {
            String function = substituted.substring(0, currOffset - 1).trim();
            ITemplateFunction templateFunction = model.getTemplateFunction(function);
            if (templateFunction != null) {
                parts.set(0, templateName.substring(currOffset));
                try {
                    String plainContent = templateFunction.parseFunction(parts, model, src2, currOffset, src2.length, isSubst);
                    if (plainContent != null) {
                        return plainContent;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return "";
        }
        Map<String, String> parameterMap = TemplateParser.createParameterMap(objs, model);
        INamespace namespace = model.getNamespace();
        ParsedPageName parsedPagename = ParsedPageName.parsePageName(model, templateName, namespace.getTemplate(), true, false);
        if (!parsedPagename.valid) {
            return "{{" + parsedPagename.pagename + "}}";
        }
        String plainContent = null;
        try {
            plainContent = model.getRawWikiContent(parsedPagename, parameterMap);
        }
        catch (WikiModelContentException wikiModelContentException) {
            // empty catch block
        }
        if (plainContent != null) {
            return Safesubst.parsePreprocess(plainContent, model, parameterMap);
        }
        return "";
    }

    public static String parsePreprocess(String content, IWikiModel model, Map<String, String> templateParameterMap) {
        if (content == null || content.length() == 0) {
            return "";
        }
        int startIndex = Util.indexOfTemplateParsing(content);
        if (startIndex < 0) {
            return Utils.trimNewlineLeft(content);
        }
        StringBuilder buf = new StringBuilder(content.length());
        try {
            TemplateParser.parsePreprocessRecursive(startIndex, content, model, buf, false, false, templateParameterMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Utils.trimNewlineLeft(buf.toString());
    }
}

