/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.io.ClasspathResourceLoader;
import cucumber.runtime.io.FileResourceLoader;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;

public class MultiLoader
implements ResourceLoader {
    public static final String CLASSPATH_SCHEME = "classpath:";
    private final ClasspathResourceLoader classpath;
    private final FileResourceLoader fs;

    public MultiLoader(ClassLoader classLoader) {
        this.classpath = new ClasspathResourceLoader(classLoader);
        this.fs = new FileResourceLoader();
    }

    @Override
    public Iterable<Resource> resources(String path, String suffix) {
        if (MultiLoader.isClasspathPath(path)) {
            return this.classpath.resources(MultiLoader.stripClasspathPrefix(path), suffix);
        }
        return this.fs.resources(path, suffix);
    }

    public static String packageName(String gluePath) {
        if (MultiLoader.isClasspathPath(gluePath)) {
            gluePath = MultiLoader.stripClasspathPrefix(gluePath);
        }
        return gluePath.replace('/', '.').replace('\\', '.');
    }

    private static boolean isClasspathPath(String path) {
        return path.startsWith(CLASSPATH_SCHEME);
    }

    private static String stripClasspathPrefix(String path) {
        return path.substring(CLASSPATH_SCHEME.length());
    }
}

