/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.table;

import cucumber.api.DataTable;
import cucumber.deps.difflib.Delta;
import cucumber.deps.difflib.DiffUtils;
import cucumber.deps.difflib.Patch;
import cucumber.runtime.table.DiffableRow;
import cucumber.runtime.table.TableDiffException;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Row;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableDiffer {
    private final DataTable orig;
    private final DataTable other;

    public TableDiffer(DataTable origTable, DataTable otherTable) {
        this.checkColumns(origTable, otherTable);
        this.orig = origTable;
        this.other = otherTable;
    }

    private void checkColumns(DataTable a2, DataTable b) {
        if (a2.topCells().size() != b.topCells().size()) {
            throw new IllegalArgumentException("Tables must have equal number of columns:\n" + a2 + "\n" + b);
        }
    }

    public void calculateDiffs() throws TableDiffException {
        Patch patch = DiffUtils.diff(this.orig.diffableRows(), this.other.diffableRows());
        List<Delta> deltas = patch.getDeltas();
        if (!deltas.isEmpty()) {
            Map<Integer, Delta> deltasByLine = this.createDeltasByLine(deltas);
            throw new TableDiffException(this.createTableDiff(deltasByLine));
        }
    }

    private DataTable createTableDiff(Map<Integer, Delta> deltasByLine) {
        ArrayList<DataTableRow> diffTableRows = new ArrayList<DataTableRow>();
        List<List<String>> rows = this.orig.raw();
        for (int i = 0; i < rows.size(); ++i) {
            Delta delta = deltasByLine.get(i);
            if (delta == null) {
                diffTableRows.add(this.orig.getGherkinRows().get(i));
                continue;
            }
            this.addRowsToTableDiff(diffTableRows, delta);
        }
        Delta remainingDelta = deltasByLine.get(rows.size());
        if (remainingDelta != null) {
            this.addRowsToTableDiff(diffTableRows, remainingDelta);
        }
        return new DataTable(diffTableRows, this.orig.getTableConverter());
    }

    private void addRowsToTableDiff(List<DataTableRow> diffTableRows, Delta delta) {
        if (delta.getType() == Delta.TYPE.CHANGE || delta.getType() == Delta.TYPE.DELETE) {
            List<?> deletedLines = delta.getOriginal().getLines();
            for (DiffableRow row : deletedLines) {
                diffTableRows.add(new DataTableRow(row.row.getComments(), row.row.getCells(), row.row.getLine(), Row.DiffType.DELETE));
            }
        }
        List<?> insertedLines = delta.getRevised().getLines();
        for (DiffableRow row : insertedLines) {
            diffTableRows.add(new DataTableRow(row.row.getComments(), row.row.getCells(), row.row.getLine(), Row.DiffType.INSERT));
        }
    }

    private Map<Integer, Delta> createDeltasByLine(List<Delta> deltas) {
        HashMap<Integer, Delta> deltasByLine = new HashMap<Integer, Delta>();
        for (Delta delta : deltas) {
            deltasByLine.put(delta.getOriginal().getPosition(), delta);
        }
        return deltasByLine;
    }
}

