/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.dom.DOMMediaList;
import java.net.URL;
import org.dom4j.Element;
import org.dom4j.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DOM4JCSSStyleSheet
extends BaseCSSStyleSheet
implements Cloneable {
    Element ownerElement;

    public DOM4JCSSStyleSheet(CSSStyleSheetFactory factory, Element ownerElement, DOMMediaList media, CSSRule ownerRule) {
        super(factory, media, ownerRule);
        this.ownerElement = ownerElement;
    }

    public DOM4JCSSStyleSheet(CSSStyleSheetFactory factory, Element ownerElement, DOMMediaList media) {
        this(factory, ownerElement, media, null);
    }

    public URL getDocumentBaseURL() {
        return ((XHTMLDocument)this.ownerElement.getDocument()).getBaseURL();
    }

    public Element getDOM4JOwnerElement() {
        return this.ownerElement;
    }

    public CSSStyleDeclaration getComputedStyle(CSSStylableElement elm, String pseudoElt) {
        ComputedCSSStyle style = (DOM4JCSSStyleDeclaration)elm.getStyle();
        style = this.computeStyle(new DOM4JCSSStyleDeclaration(), elm.getSelectorMatcher(), style, pseudoElt);
        ((DOM4JCSSStyleDeclaration)style).setPeerNode((Node)elm);
        return style;
    }

    public Object clone() throws CloneNotSupportedException {
        DOM4JCSSStyleSheet myClone = new DOM4JCSSStyleSheet(this.getStyleSheetFactory(), this.getDOM4JOwnerElement(), (DOMMediaList)this.getMedia(), this.getOwnerRule());
        myClone.setTitle(this.getTitle());
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.setHref(this.getHref());
        myClone.setNamespaceURI(this.getNamespaceURI());
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = (CSSRuleArrayList)this.cssRules.clone();
        return myClone;
    }
}

