/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.dom.SelectorMatcher;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DOMSelectorMatcher
extends SelectorMatcher {
    private String idAttr = null;
    Element element;

    public DOMSelectorMatcher(Element elm) {
        this.element = elm;
        this.setTagname(elm.getTagName().intern());
        Node parent = elm.getParentNode();
        if (parent != null) {
            this.setParentTagname(parent.getLocalName().intern());
        }
        this.setClassAttribute(elm.getAttribute("class"));
        this.idAttr = elm.getAttribute("id");
    }

    public SelectorMatcher getParentSelectorMatcher() {
        Node parent = this.element.getParentNode();
        if (parent instanceof Element) {
            return new DOMSelectorMatcher((Element)parent);
        }
        return null;
    }

    public SelectorMatcher getPreviousSiblingSelectorMatcher() {
        Node sibling = this.element.getPreviousSibling();
        if (sibling instanceof Element) {
            return new DOMSelectorMatcher((Element)sibling);
        }
        return null;
    }

    public boolean isFirstChild() {
        return this.element.getPreviousSibling() == null;
    }

    public String getAttributeValue(String attrName) {
        return this.element.getAttribute(attrName);
    }

    public boolean hasAttribute(String attrName) {
        return this.element.hasAttribute(attrName);
    }

    public String getLanguage() {
        String lang = this.element.getAttribute("lang");
        while (lang.length() == 0) {
            Node parent = this.element.getParentNode();
            if (parent instanceof Element) break;
            lang = ((Element)parent).getAttribute("lang");
        }
        if (lang.length() == 0) {
            lang = null;
        }
        return lang;
    }

    public String getId() {
        return this.idAttr;
    }
}

