/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.j2d;

import info.informatica.doc.style.css.AbstractStyleDatabase;
import info.informatica.doc.style.css.property.ColorIdentifiers;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class Java2DStyleDatabase
extends AbstractStyleDatabase {
    private GraphicsConfiguration gConfiguration = null;
    private short naturalUnit = (short)5;
    static Logger log = Logger.getLogger((String)Java2DStyleDatabase.class.getName());

    public String getDefaultGenericFontFamily(String genericFamily) {
        String fontName = null;
        if (genericFamily.equals("serif")) {
            fontName = "Serif";
        } else if (genericFamily.equals("sans serif")) {
            fontName = "SansSerif";
        } else if (genericFamily.equals("monospace")) {
            fontName = "Monospaced";
        }
        return fontName;
    }

    public boolean isFontFamilyAvailable(String fontFamily) {
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fontNames.length) {
            if (fontNames[i].equalsIgnoreCase(fontFamily)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected GraphicsConfiguration getGraphicsConfiguration() {
        if (this.gConfiguration == null) {
            this.gConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return this.gConfiguration;
    }

    public void setGraphicsConfiguration(GraphicsConfiguration configuration) {
        this.gConfiguration = configuration;
    }

    protected float cmToPixels(float cm) {
        double height;
        double width;
        try {
            GraphicsConfiguration gcf = this.getGraphicsConfiguration();
            width = gcf.getBounds().getWidth();
            height = gcf.getBounds().getHeight();
        }
        catch (UnsupportedOperationException e) {
            width = 1024.0;
            height = 768.0;
        }
        double diag = Math.sqrt(width * width + height * height);
        return (float)((double)cm * diag / 43.18);
    }

    protected float pxTocm(int px) {
        double height;
        double width;
        try {
            GraphicsConfiguration gcf = this.getGraphicsConfiguration();
            width = gcf.getBounds().getWidth();
            height = gcf.getBounds().getHeight();
        }
        catch (UnsupportedOperationException e) {
            width = 1024.0;
            height = 768.0;
        }
        double diag = Math.sqrt(width * width + height * height);
        return (float)((double)px * 43.18 / diag);
    }

    protected float deviceResolutionFactor() {
        return (float)(this.getGraphicsConfiguration().getBounds().getHeight() / 768.0);
    }

    public int getFontSizeFromIdentifier(String familyName, String fontSizeIdentifier) throws DOMException {
        float sz;
        float factor = Math.max(0.9f, this.deviceResolutionFactor());
        if (fontSizeIdentifier.equals("xx-small")) {
            sz = 8.0f * factor;
        } else if (fontSizeIdentifier.equals("x-small")) {
            sz = 9.0f * factor;
        } else if (fontSizeIdentifier.equals("small")) {
            sz = 10.0f * factor;
        } else if (fontSizeIdentifier.equals("medium")) {
            sz = 12.0f * factor;
        } else if (fontSizeIdentifier.equals("large")) {
            sz = 14.0f * factor;
        } else if (fontSizeIdentifier.equals("x-large")) {
            sz = 16.0f * factor;
        } else if (fontSizeIdentifier.equals("xx-large")) {
            sz = 18.0f * factor;
        } else {
            throw new DOMException(15, "Unknown size identifier: " + fontSizeIdentifier);
        }
        return Math.round(sz);
    }

    public float getWidthSize(String widthIdentifier) throws DOMException {
        float factor = Math.max(0.62f, this.deviceResolutionFactor());
        if ("thin".equals(widthIdentifier)) {
            return 0.5f * factor;
        }
        if ("thick".equals(widthIdentifier)) {
            return 2.0f * factor;
        }
        if ("medium".equals(widthIdentifier)) {
            return 1.0f * factor;
        }
        throw new DOMException(12, "Unknown identifier " + widthIdentifier);
    }

    public short getNaturalUnit() {
        return this.naturalUnit;
    }

    public void setNaturalUnit(short naturalUnit) {
        this.naturalUnit = naturalUnit;
    }

    public float getDocumentHeight() {
        return this.floatValueConversion((float)this.getGraphicsConfiguration().getBounds().getHeight(), (short)5, this.getNaturalUnit());
    }

    public float getDocumentWidth() {
        return this.floatValueConversion((float)this.getGraphicsConfiguration().getBounds().getWidth(), (short)5, this.getNaturalUnit());
    }

    public static Color getAWTColor(CSSPrimitiveValue cssColor) {
        Color awtcolor = null;
        if (cssColor != null) {
            switch (cssColor.getPrimitiveType()) {
                case 25: {
                    RGBColor color = cssColor.getRGBColorValue();
                    CSSPrimitiveValue red = color.getRed();
                    CSSPrimitiveValue green = color.getGreen();
                    CSSPrimitiveValue blue = color.getBlue();
                    switch (red.getPrimitiveType()) {
                        case 2: {
                            awtcolor = new Color(Java2DStyleDatabase.clipColorValue(red.getFloatValue((short)2) / 100.0f), Java2DStyleDatabase.clipColorValue(green.getFloatValue((short)2) / 100.0f), Java2DStyleDatabase.clipColorValue(blue.getFloatValue((short)2) / 100.0f));
                            break;
                        }
                        case 1: {
                            try {
                                awtcolor = new Color(Java2DStyleDatabase.clipColorValue((int)red.getFloatValue((short)1)), Java2DStyleDatabase.clipColorValue((int)green.getFloatValue((short)1)), Java2DStyleDatabase.clipColorValue((int)blue.getFloatValue((short)1)));
                                break;
                            }
                            catch (IllegalArgumentException e) {
                                log.error((Object)e);
                            }
                        }
                    }
                    break;
                }
                case 21: {
                    String s = ColorIdentifiers.getInstance().getColor(cssColor.getStringValue());
                    if (s != null) {
                        try {
                            awtcolor = Color.decode(s);
                        }
                        catch (NumberFormatException e) {
                            log.error((Object)e);
                        }
                        break;
                    }
                    awtcolor = Color.getColor(cssColor.getStringValue());
                    break;
                }
                case 19: {
                    String encoded = cssColor.getStringValue();
                    if (encoded.charAt(0) != '#') break;
                    try {
                        awtcolor = Color.decode(encoded);
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)e);
                    }
                    break;
                }
                case 1: {
                    awtcolor = new Color((int)cssColor.getFloatValue((short)1));
                }
            }
        }
        return awtcolor;
    }

    protected static int clipColorValue(int color) {
        return Math.max(Math.min(255, color), 0);
    }

    protected static float clipColorValue(float color) {
        return Math.max(Math.min(1.0f, color), 0.0f);
    }
}

