/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.agent;

import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.visual.ElementReplacer;

import java.net.URL;

/**
 * User agent for rendering documents.
 * 
 * @author Carlos Amengual
 *
 */
public interface UserAgent<C> {

	/**
	 * Registers an URL for downloading with this user agent.
	 * 
	 * @param url the URL to be downloaded.
	 * @return the downloader for the URL.
	 */
	public ResourceDownloader<C> download(URL url);

	/**
	 * Adds a download listener for asynchronous retrieval of resources 
	 * (embedded images, etc.)
	 * <p>
	 * In the process, it creates a resource downloader object.
	 * 
	 * @param url the URL for the resource to be downloaded.
	 * @param listener the download listener.
	 */
	public void addDownloadListener(URL url, DownloadListener<C> listener);

	/**
	 * Gets the resource downloader for the given URL, creating one if 
	 * none exists.
	 * 
	 * @param url the URL.
	 * @return the resource downloader.
	 */
	public ResourceDownloader<C> getResourceDownloader(URL url);

	/**
	 * Gets the element replacer for the given namespace URI.
	 * 
	 * @param namespaceUri the namespace URI of the requested replacer. 
	 * If passed an empty string, will return the replacer for the 
	 * namespace of XHTML. 
	 * @return the element replacer, or null if the namespace is not 
	 * known to this user agent. 
	 */
	public ElementReplacer<C> getElementReplacer(String namespaceUri);

	/**
	 * Sets the element replacer for the given namespace URI.
	 * 
	 * @param namespaceUri the namespace URI of the supplied replacer. 
	 * @param replacer the element replacer.
	 */
	public void setElementReplacer(String namespaceUri, ElementReplacer<C> replacer);

	/**
	 * Gets the style database used for the styles applied by this agent. 
	 * 
	 * @return the style database.
	 */
	public StyleDatabase getStyleDatabase();

}