/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import java.util.Iterator;

import org.dom4j.Element;
import org.dom4j.QName;
import org.w3c.dom.css.CSSStyleDeclaration;

/**
 * Version of CSSStylableElement that caches computed style values;
 * 
 * @author Carlos Amengual
 *
 */
class CachedCSSStylableElement extends CSSStylableElement {

	private static final long serialVersionUID = 1L;
	
	private CSSStyleDeclaration cachedComputedStyle = null;
	
	private int cacheSerial = Integer.MIN_VALUE;

	CachedCSSStylableElement(String name) {
		super(name);
	}

	CachedCSSStylableElement(QName qname) {
		super(qname);
	}

    CachedCSSStylableElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

	@Override
	public CSSStyleDeclaration getComputedStyle() {
		int documentCacheSerial = getDocument().getStyleCacheSerial();
		if(cachedComputedStyle == null || cacheSerial != documentCacheSerial){
			cacheSerial = documentCacheSerial;
			cachedComputedStyle = super.getComputedStyle();
		}
		return cachedComputedStyle;
	}

	/**
	 * Notifies the element about any change in the style attribute.
	 *
	 */
	public void onStyleModify() {
		// clear cached style
		cachedComputedStyle = null;
		// Cascade notification
		Iterator elements = elementIterator();
		while(elements.hasNext()) {
			Element element = (Element) elements.next();
			if(element instanceof CachedCSSStylableElement) {
				((CachedCSSStylableElement)element).onStyleModify();
			}
		}
	}

}
