/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import info.informatica.doc.style.css.property.AttributeToStyle;

import org.dom4j.QName;

/**
 * Cached table cell element.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class CachedTableCellElement extends CachedCSSStylableElement {

	private static final long serialVersionUID = 1L;

	protected CachedTableCellElement(String name) {
		super(name);
	}

	protected CachedTableCellElement(QName qname) {
		super(qname);
	}

    CachedTableCellElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

	protected String inlineStyle() {
		StringBuilder buf;
		String styleAttr = attributeValue("style");
		if(styleAttr != null) {
			buf = new StringBuilder(36 + styleAttr.length());
			buf.append(styleAttr);
			if(styleAttr.charAt(styleAttr.length() - 1) != ';') {
				buf.append(';');
			}
		} else {
			buf = new StringBuilder(36);
		}
		AttributeToStyle.bgcolor(attributeValue("bgcolor"), buf);
		AttributeToStyle.width(attributeValue("width"), buf);
		AttributeToStyle.height(attributeValue("height"), buf);
		return buf.toString();
	}

}
