/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;

import org.dom4j.dom.DOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/**
 * Style declaration for DOM4J.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class DOM4JCSSStyleDeclaration extends ComputedCSSStyle {

	public DOM4JCSSStyleDeclaration() {
		super();
	}

	public DOM4JCSSStyleDeclaration(BaseCSSStyleDeclaration copiedObject) {
		super(copiedObject);
	}

	public String getPeerXPath() {
		Node node = getPeerNode();
		if (node != null && node instanceof DOMElement) {
			return ((DOMElement)node).getPath();
		}
		return "";
	}

	public String getParentXPath() {
		Node node = getPeerNode();
		if (node != null) {
			Element parent = (Element) node.getParentNode();
			if (parent != null && parent instanceof DOMElement) {
				return ((DOMElement)parent).getPath();
			}
		}
		return "";
	}

	public DOM4JCSSStyleDeclaration getParentComputedStyle() {
		DOM4JCSSStyleDeclaration parentCss = null;
		Node node = getPeerNode();
		if (node != null) {
			Element parent = (Element) node.getParentNode();
			if (parent != null && (parent instanceof CSSStylableElement)) {
				parentCss = (DOM4JCSSStyleDeclaration) ((CSSStylableElement)parent).getComputedStyle();
				if (parentCss != null) {
					parentCss.setStyleDatabase(getStyleDatabase());
				}
			}
		}
		return parentCss;
	}

	/**
	 * Gets the (whitespace-trimmed) text content of the 
	 * node associated to this style.
	 * 
	 * @return the text content, or the empty string if the box 
	 * has no text.
	 */
	@Override
	public String getText() {
		String text;
		Node node = getPeerNode();
		if(node instanceof DOMElement) {
			text = ((DOMElement)node).getTextTrim();
		} else if(node instanceof org.dom4j.Node) {
			text = ((org.dom4j.Node)node).getText().trim().replace("  ", " ");
		} else {
			// TODO: compress white spaces
			text = node.getTextContent().trim().replace("  ", " ");
		}
		return text;
	}

	@Override
	public DOM4JCSSStyleDeclaration clone() {
		DOM4JCSSStyleDeclaration styleClone = new DOM4JCSSStyleDeclaration(this);
		styleClone.setPeerNode(getPeerNode());
		styleClone.setStyleDatabase(getStyleDatabase());
		return styleClone;
	}
}
