/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import info.informatica.doc.style.css.StyleDatabase;

import org.dom4j.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;

/**
 * Font element.<p>
 * Provides equivalent CSS style for this deprecated element.
 * 
 * @author Carlos Amengual
 *
 */
class FontElement extends CSSStylableElement {

	private static final long serialVersionUID = 1L;
	
	FontElement(String name) {
		super(name);
	}

	FontElement(QName qname) {
		super(qname);
	}

    FontElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

	/**
	 * Gets the style coming from this deprecated element.
	 * <p>Any style specified through the <code>style</code> attribute 
	 * of this deprecated element is ignored.
	 * 
	 * @return the equivalent style declaration, or null if the attributes 
	 * could not be parsed or interpreted appropriately.
	 */
	public CSSStyleDeclaration getStyle() {
		DOM4JCSSStyleDeclaration styledecl = new DOM4JCSSStyleDeclaration();
		StringBuilder equivStyle = new StringBuilder(64);
		String attr = attributeValue("face");
		if (attr != null && attr.length() > 0) {
			equivStyle.append("font-family: ").append(attr).append("; ");
		}
		attr = attributeValue("size");
		if (attr != null && attr.length() > 0) {
			equivStyle.append("font-size: ").append(translateFontSize(attr)).append("; ");
		}
		attr = attributeValue("color");
		if (attr != null && attr.length() > 0) {
			equivStyle.append("color: ").append(attr).append(";");
		}
		if(equivStyle.length() > 0) {
			try {
				styledecl.setCssText(equivStyle.toString());
				styledecl.setPeerNode(this);
				StyleDatabase styleDb = ((XHTMLDocument) getDocument()).
					getStyleDatabase();
				if(styleDb != null && styledecl.getStyleDatabase() == null){
					styledecl.setStyleDatabase(styleDb);
				}
			} catch (DOMException e) {
				log.error("Could not parse style", e);
				styledecl = null;
			}
		} else {
			styledecl = null;
		}
		return styledecl;
	}

	private CharSequence translateFontSize(CharSequence size) {
		// It is assumed was previously checked that size.length() 
		// is greater than zero.
		if(size.charAt(0) == '+') {
			return "larger";
		} else if(size.charAt(0) == '-') {
			return "smaller";
		} else {
			return size;
		}
	}

}
