/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.dom4j;

import java.io.IOException;
import java.io.InputStream;

import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Node;
import org.dom4j.QName;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;

/**
 * LINK element.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
class LinkElement extends XHTMLElement implements StyleDefiner {

	private static final long serialVersionUID = 2L;

	static Logger log = Logger.getLogger(LinkElement.class.getName());

	LinkElement(String name) {
		super(name);
	}

	LinkElement(QName qname) {
		super(qname);
	}

    LinkElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

	/* (non-Javadoc)
	 * @see info.informatica.doc.dom4j.StyleDefiner#mergeStyle()
	 */
	public void mergeStyle() throws CSSException {
		String rel = attributeValue("rel");
		if(rel != null && rel.equalsIgnoreCase("stylesheet")){
			String href = attributeValue("href");
			if (href != null) {
				InputSource source = new InputSource();
				InputStream is;
				try {
					is = getDocument().openStream(href);
				} catch (IOException e) {
					log.error("Error getting style from: " + href, e);
					return;
				}
				source.setByteStream(is);
				try {
					getDocument().addStyleSheet(source);
				} catch (DOMException e) {
					log.error("Error adding style from: " + href, e);
				} catch (CSSException e) {
					log.error("Error adding style from: " + href, e);
					throw e;
				} catch (IOException e) {
					log.error("Error adding style from: " + href, e);
				} finally {
					try {
						is.close();
					} catch (IOException e) {}
				}
			}
		}
	}

	@Override
	protected void childAdded(Node node) {
		super.childAdded(node);
		if(node instanceof Attribute){
			XHTMLDocument doc = getDocument();
			if(doc != null) {
				doc.onStyleModify();
			}
		}
	}

	// Maybe this is enough, and the above method just duplicates effort.
	@Override
	protected void childRemoved(Node node) {
		super.childRemoved(node);
		if(node instanceof Attribute){
			getDocument().onStyleModify();
		}
	}

}
