/*

 Copyright (c) 2005-2011, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.pdf.itext;

import org.dom4j.Element;

import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.style.css.visual.CSSReplacementException;
import info.informatica.doc.style.css.visual.box.AbstractReplacedBox;

import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseField;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.TextField;

/**
 * PDF text form field replaced element box.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class PDFInputTextReplacedBox extends AbstractReplacedBox<Image> {
	
	public PDFInputTextReplacedBox(CSSStylableElement elem) {
		super(elem);
	}

	public void init(UserAgent<Image> agent) throws CSSReplacementException {
	}

	public BaseField createPDFField(PdfWriter writer) {
		TextField field = new TextField(writer, new Rectangle(
				getIntrinsicWidth(), getIntrinsicHeight()),
			((Element)((DOM4JCSSStyleDeclaration)getComputedStyle())
					.getPeerNode()).attributeValue("name"));
		return field;
	}

	public float getIntrinsicHeight() {
		return getFontSize();
	}

	public float getIntrinsicWidth() {
		String size = getReplacedElement().attributeValue("size");
		if(size == null || size.length() == 0){
			size = "20";
		}
		int iSize;
		try {
			iSize = Integer.parseInt(size);
		} catch(NumberFormatException e) {
			iSize = 20;
		}
		return textLengthToNaturalUnit(iSize);
	}


}
