/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css;

import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;

/**
 * CSS Error handler.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface CSSErrorHandler {
	
	/**
	 * Report an unqualified error.
	 * @param message a descriptive message.
	 */
	public void error(String message);

	/**
	 * Report an error.
	 * @param message a descriptive message.
	 * @param t the exception causing the error.
	 */
	public void error(String message, Throwable t);

	public void error(String message, Throwable t, CSSStyleSheet sheet);

	public void error(String message, Throwable t, CSSRule rule);

	public void error(String message, String property, CSSValue value);

}
