/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css;

/**
 * To be implemented by classes that make use of a style database.
 * 
 * @author Carlos Amengual
 *
 */
public interface StyleDatabaseAware {

	/**
	 * Gets the style database.
	 * 
	 * @return the style database, or null if no database is set.
	 */
	public StyleDatabase getStyleDatabase();

	/**
	 * Sets the style database.
	 * 
	 * @param styleDb the style database.
	 */
	public void setStyleDatabase(StyleDatabase styleDb);

}